#include <libintl.h>
#include <utils/guile.hh>

SCM scm_dgettext(SCM textdomain, SCM msgid)
{
	SCM_ASSERT(SCM_STRINGP(textdomain), textdomain, SCM_ARG1, "dgettext");
	SCM_ASSERT(SCM_STRINGP(msgid), msgid, SCM_ARG2, "dgettext");

	return scm::scm(dgettext(scm::scm(textdomain).as_str().c_str(),
	                         scm::scm(msgid).as_str().c_str())).as_scm();
}

SCM scm_bind_textdomain_codeset(SCM textdomain, SCM codeset)
{
	SCM_ASSERT(SCM_STRINGP(textdomain), textdomain, SCM_ARG1, "dgettext");
	SCM_ASSERT(SCM_STRINGP(codeset), codeset, SCM_ARG2, "dgettext");

	const char *result = bind_textdomain_codeset(scm::scm(textdomain).as_str().c_str(),
	                                             scm::scm(codeset).as_str().c_str());

	return result? scm::scm(result).as_scm() : SCM_BOOL_F;
}

void init_scm_gettext(void)
{
	scm_c_define_gsubr("dgettext", 2, 0, 0,
			   (SCM (*)())scm_dgettext);
	scm_c_define_gsubr("bind-textdomain-codeset", 2, 0, 0,
			   (SCM (*)())scm_bind_textdomain_codeset);
}
