(define printers (woo-read-names "/cups/printers"))
(define (selected-printer) (look-attr-get 'printers text))

(define (selected-printer-cmd)
  (string-append "/cups/printers/" (selected-printer)))

(define (printer-to-widget x)
  (look-attr x text (later (woo-read (selected-printer-cmd) x))))

(define (labeled-label name txt)
  (hbox (label txt) (id name (label ""))))

;list of installed printers
(define (make-printer-list)
  (vbox sizepolicy "fixed"
    (label "Installed printers:")
    (if (null? printers)
      (listbox width 20 height 20)
      (id 'printers (listbox width 20 height 20 
			     (map label printers)
			     (on-select 
			       (map printer-to-widget '(info default state uri))))))))

;printer's summary
(define (make-printer-info)
  (hbox spacing 1 margin 3
	(vbox sizepolicy "fixed"
	  (map (lambda (x)
		 (label x font "-*-*-bold-*-*--*-*-*-*-*-*-*-*"))
	       '("Summary:" "Default:" "Status:" "Uri:")))
	(vbox
	  (map (lambda (x) (id x (label ""))) '(info default state uri)))))

;buttons for add/remove printers
(define (buttons)
  (hbox
    (button "Add new printer")
    (button "Remove printer"
	    enabled (if (null? printers) "no" "yes"))))

;main window definitions
(vbox
  (hbox
    (make-printer-list)
   (make-printer-info))
  (buttons))

