;temporary hack for testing
(on-error (look-view "/printers/vendor" 'printer-name (later (get-value 'printer-name))))

(on-prev (look-view "/printers/connection"))
(on-next (later (create-printer))
	 (look-view "/printers/vendor" 'printer-name (later (get-value 'printer-name))))

(disable-next)

(define (get-value x) (look-attr-get x text))
(define (non-empty? x) (> (string-length x) 0))

;generate list with only defined options
(define (command-options)
  (fold
    (lambda (x res)
      (let ((value (get-value x)))
	(if (non-empty? value)
	  (append res (list x value))
	  res)))
    '()
    '(smb-user smb-password smb-workgroup smb-host smb-share)))

(define (cmd-printer-name)
  (string-append "/cups/printers/" (get-value 'printer-name)))

(define (create-printer)
  `(,(cmd-printer-name) action "new" ,@(command-options)))

(define (can-next)
  (look-attr next-button enabled
  (if (and (non-empty? (get-value 'smb-host))
	   (non-empty? (get-value 'smb-share))
	   (non-empty? (get-value 'printer-name)))
    "yes"
    "no")))

(label "SMB (Windows 9x/NT) printer options:"
       font "-*-*-bold-*-*--*-*-*-*-*-*-*-*")
(hbox spacing 1 margin 3
      (vbox sizepolicy "fixed"
	    (map (lambda (x)
		   (label x font "-*-*-bold-*-*--*-*-*-*-*-*-*-*" height 3))
		 '("Local name:" "SMB server host:" "Share name:" "User name:" "Password:" "Workgroup")))
      (vbox
	(map (lambda (x) (id x (edit "" height 3 (on-change (later (can-next))))))
	     '(printer-name smb-host smb-share smb-user smb-password smb-workgroup))))

