Name:		alterator
Version:	1.99
Release:	alt47

Summary:	ALT Linux configurator engine
License:	GPL
Group:		System/Configuration/Other

Source:		%name-%version.tar.bz2

BuildPreReq: libdbus-devel >= 0.34

# Automatically added by buildreq on Thu Jun 23 2005 (-bi)
BuildRequires: cook gcc-c++ guile16-devel kookish libdbus-devel libdbus-qt-devel libqt3-devel libstdc++-devel pkgconfig 

#cook suxx
ExclusiveArch: i586 i686 i386

Requires: guile16

#for backward compatibility
Requires: %name-common = %version-%release %name-look-qt = %version-%release

%description
ALT Linux configurator engine

%package common
Summary: Common ALTerator files and directories
License: GPL
Group: System/Configuration/Other

%description common
Common ALTerator files and directories

%package look-qt
Summary: Graphical qt-based alterator frontend
License: GPL
Group: System/Configuration/Other

%description look-qt
Graphical qt-based alterator frontend

%prep
%setup -q

#replace default common directory
pushd scripts
%__subst s,\.\./common/\",%_datadir/%name/common/\", *
popd

#cook bug hackaround
%__subst '/^vc:/d;/^cxxflags:/d;/^cflags:/d;/^ldflags:/d;' \=config

%build
cook -no_list -no_include_cooked_warning -b /usr/share/kookish/main.cook \
	vc=none cxxflags="$RPM_OPT_FLAGS -fPIC -I%_libdir/qt3/include `pkg-config dbus-1 --cflags`" \
	cflags="$RPM_OPT_FLAGS -fPIC -I%_libdir/qt3/include" \
	ldflags='-Wl,-rpath-link bin -L%_libdir/qt3/lib' \
	all

%install
#create special directories
%__install -d -m755 $RPM_BUILD_ROOT%_prefix/lib/%name/{backend,backend2,model}
%__install -d -m755 $RPM_BUILD_ROOT%_cachedir/%name
%__install -d -m755 $RPM_BUILD_ROOT%_sysconfdir/%name
%__install -d -m755 $RPM_BUILD_ROOT%_datadir/%name/common
%__install -d -m755 $RPM_BUILD_ROOT%_datadir/locale/ru/LC_MESSAGES/

%__install -d -m755 $RPM_BUILD_ROOT%_datadir/%name/maps
%__install -d -m755 $RPM_BUILD_ROOT%_datadir/%name/layouts
%__install -d -m755 $RPM_BUILD_ROOT%_datadir/%name/ui

cook -no_list -no_include_cooked_warning -b /usr/share/kookish/main.cook \
	vc=none cxxflags="$RPM_OPT_FLAGS -fPIC -I%_libdir/qt3/include `pkg-config dbus-1 --cflags`" \
	cflags="$RPM_OPT_FLAGS -fPIC -I%_libdir/qt3/include" \
	ldflags='-Wl,-rpath-link bin -L%_libdir/qt3/lib' \
	destdir=$RPM_BUILD_ROOT \
	install

#common scheme data
install -m644 common/* $RPM_BUILD_ROOT%_datadir/%name/common/
cp -a modules/ $RPM_BUILD_ROOT%_datadir/%name/

#setup as guile modules
%__install -d $RPM_BUILD_ROOT%_datadir/guile/1.6/
ln -sf %_datadir/%name/modules/alterator  $RPM_BUILD_ROOT%_datadir/guile/1.6/alterator

#install scripts
for i in scripts/*
do
	%__install -pm755 $i $RPM_BUILD_ROOT%_bindir
done

msgfmt po/ru.po -o $RPM_BUILD_ROOT%_datadir/locale/ru/LC_MESSAGES/alterator-common.mo

install -d $RPM_BUILD_ROOT%_sysconfdir/rpm/macros.d
cat >$RPM_BUILD_ROOT%_sysconfdir/rpm/macros.d/%name<<EOF
%%_alterator_libdir %%([ ! -f %_datadir/%name/dialog-functions.scm ])%_prefix/lib/%name

%%_alterator_modeldir %_alterator_libdir/model
%%_alterator_backenddir %_alterator_libdir/backend
%%_alterator_backend2dir %_alterator_libdir/backend2

EOF


%find_lang %name-common

%post -p %post_ldconfig
%postun -p %postun_ldconfig

%define _altdata_dir %_datadir/alterator
%define _altlib_dir %_prefix/lib/alterator

%files
%_sysconfdir/rpm/macros.d/*
%doc doc/howto.txt doc/cache.txt doc/look-cmd.txt doc/simple_layout.scm doc/samples
%_bindir/*
%_libdir/*.so.*
%_libdir/libguile*.so
%exclude %_libdir/libguile-qtlook.so*

%files common -f %name-common.lang
%_cachedir/%name
%_sysconfdir/%name
%dir %_altlib_dir
%dir %_altlib_dir/backend
%dir %_altlib_dir/backend2
%dir %_altlib_dir/model
%_datadir/%name
%_datadir/guile/1.6/alterator
%exclude %_datadir/%name/common/lookout-qt*

%files look-qt
%_datadir/%name/common/lookout-qt*
%_libdir/libguile-qtlook.so*

%changelog
* Mon Jul 18 2005 Stanislav Ievlev <inger@altlinux.org> 1.99-alt45
- minor fixes

* Thu Jul 14 2005 Stanislav Ievlev <inger@altlinux.org> 1.99-alt44
- rebuild with new dbus
- some little improvements

* Tue Jul 12 2005 Stanislav Ievlev <inger@altlinux.org> 1.99-alt42
- another qt tunings
- fixed brook work

* Wed Jul 06 2005 Stanislav Ievlev <inger@altlinux.org> 1.99-alt41
- fix and improve latest feature
- added alterator-standalone

* Tue Jul 05 2005 Stanislav Ievlev <inger@altlinux.org> 1.99-alt40.3
- goto now framed, globals now stackable in frames, more modules

* Mon Jul 04 2005 Stanislav Ievlev <inger@altlinux.org> 1.99-alt40.2
- more modules

* Wed Jun 29 2005 Stanislav Ievlev <inger@altlinux.org> 1.99-alt40.1
- more modules

* Tue Jun 28 2005 Stanislav Ievlev <inger@altlinux.org> 1.99-alt40
- some new files converted to modules
- fixed problem with dialog re-fill

* Mon Jun 27 2005 Stanislav Ievlev <inger@altlinux.org> 1.99-alt39
- begin to use module system
- added groupbox widget

* Fri Jun 24 2005 Stanislav Ievlev <inger@altlinux.org> 1.99-alt38
- new hacks for design

* Thu Jun 23 2005 Stanislav Ievlev <inger@altlinux.org> 1.99-alt37
- added support for focus, acc and install3 in separate packages now

* Tue Jun 21 2005 Stanislav Ievlev <inger@altlinux.org> 1.99-alt36
- tabbox improvements

* Mon Jun 20 2005 Stanislav Ievlev <inger@altlinux.org> 1.99-alt35
- add feature for acc (on-acc-leave)
- apply patches

* Wed Jun 15 2005 Stanislav Ievlev <inger@altlinux.org> 1.99-alt34
- added tabs

* Tue Jun 14 2005 Stanislav Ievlev <inger@altlinux.org> 1.99-alt33
- incompatible look changes

* Thu Jun 09 2005 Stanislav Ievlev <inger@altlinux.org> 1.99-alt32
- preparations for standalone versions of configurators

* Tue Jun 07 2005 Stanislav Ievlev <inger@altlinux.org> 1.99-alt31
- little tuning

* Mon Jun 06 2005 Stanislav Ievlev <inger@altlinux.org> 1.99-alt30
- new improved scheme for steps and acc modules

* Fri Jun 03 2005 Stanislav Ievlev <inger@altlinux.org> 1.99-alt29
- for developers only: try to switch to new bus

* Thu Jun 02 2005 Stanislav Ievlev <inger@altlinux.org> 1.99-alt28
- for developers only: support for new bus

* Tue May 31 2005 Stanislav Ievlev <inger@altlinux.org> 1.99-alt27
- for developers only: lookout fixes and improvements
- added BUS_DEBUG support

* Fri May 27 2005 Stanislav Ievlev <inger@altlinux.org> 1.99-alt26
- for developers only: lookout fixes and improvements

* Thu May 26 2005 Stanislav Ievlev <inger@altlinux.org> 1.99-alt25
- for developers only: lookout fixes and improvements

* Wed May 25 2005 Stanislav Ievlev <inger@altlinux.org> 1.99-alt24
- for developers only: lookout fixes and improvements

* Tue May 24 2005 Stanislav Ievlev <inger@altlinux.org> 1.99-alt22
- for developers only: lookout related fixes

* Mon May 23 2005 Stanislav Ievlev <inger@altlinux.org> 1.99-alt21
- for developers only

* Wed May 18 2005 Stanislav Ievlev <inger@altlinux.org> 1.99-alt20
- little tunings

* Wed May 04 2005 Stanislav Ievlev <inger@altlinux.org> 1.99-alt19
- new snapshot
  -- improved backend format
  -- libguile-glob now in separate loadable library

* Wed Apr 27 2005 Stanislav Ievlev <inger@altlinux.org> 1.99-alt18
- new snapshot
- added hidden,text-append properties
- fixed race in barnacle
- move trigger to right place

* Mon Apr 25 2005 Stanislav Ievlev <inger@altlinux.org> 1.99-alt17
- filesystem improvements

* Fri Apr 22 2005 Stanislav Ievlev <inger@altlinux.org> 1.99-alt16
- first version of control center

* Thu Apr 21 2005 Stanislav Ievlev <inger@altlinux.org> 1.99-alt15
- new map format
- new backend format
- added logger (bordbuch)

* Wed Apr 13 2005 Stanislav Ievlev <inger@altlinux.org> 1.99-alt14
- bugfixes

* Tue Apr 12 2005 Stanislav Ievlev <inger@altlinux.org> 1.99-alt13
- current snapshot:
  - added x11 step
  - woo-read-names now with caching by default
  - added on-double-click for listbox, on-click for checkbox

* Mon Apr 04 2005 Stanislav Ievlev <inger@altlinux.org> 1.99-alt12
- alterator-network,alterator-printers now in separate packages

* Tue Mar 29 2005 Stanislav Ievlev <inger@altlinux.org> 1.99-alt11
- current snapshot:
  -- turned off building of executor/defusator/admfs
  -- added ensign (replacement of conductor based modules)
  -- added dbus support
- users stuff now in separate package named alterator-users

* Mon Mar 21 2005 Stanislav Ievlev <inger@altlinux.org> 1.99-alt10
- current snapshot:
  - removed obsoleted commander/rcommander/eval/libeval
  - first version of network config
  - include first version of timezone config
  - minor bugfixes
- local_users backend now in separate package

* Mon Mar 14 2005 Stanislav Ievlev <inger@altlinux.org> 1.99-alt9
- current snapshot:
  -- first version of printers config
  -- minor bugfixes
- added new subpackage install3.

* Fri Mar 04 2005 Stanislav Ievlev <inger@altlinux.org> 1.99-alt8
- current snapshot:
  -- admiral and rear-admiral instead of commanders
  -- gettext support
  -- useradd step for wizard
  -- many bugfixes

* Thu Feb 24 2005 Stanislav Ievlev <inger@altlinux.org> 1.99-alt7
- new subpackages:
   - common (common files and directories)
   - look-qt (graphical frontend)
   - admfs (admfs backend system)
- fixed little bug in post/postun scripts
- latest alterator snapshot with wizard engine

* Wed Feb 09 2005 Alexey Voinov <voins@altlinux.ru> 1.99-alt6
- new snapshot
- scm-look is now default
- defusator is used instead of executor (fuse disabled)

* Wed Feb 02 2005 Stanislav Ievlev <inger@altlinux.org> 1.99-alt5
- improved install3 script

* Tue Jan 25 2005 Alexey Voinov <voins@altlinux.ru> 1.99-alt4
- removed reqs on kernel-modules-fuse
- added modprobe fuse to start of the script

* Tue Jan 25 2005 Alexey Voinov <voins@altlinux.ru> 1.99-alt3
- new snapshot
- not-yet-obsolete docs packaged
- buildreqs fixed

* Thu Jan 20 2005 Alexey Voinov <voins@altlinux.ru> 1.99-alt2
- stage3 added
- root passwd changer added

* Wed Jan 19 2005 Alexey Voinov <voins@altlinux.ru> 1.99-alt1
- new version.
- old changelog (<=1.0.1) removed.
