;ready for use frame for standalone configurators or control center
(use-translation _translation_ "alterator-common")

;keyword definitions
(declare-keyword number)
(declare-keyword filename)
(declare-keyword stepfile)

;wizard specific events definitions
(declare-event on-next)
(declare-event on-prev)
(declare-event on-apply)
(declare-event on-acc-leave)

;pass all errors to subwidget handlers
(on-dbus (page 'call on-dbus sender destination interface dmember args))

;enable/disable buttons
(define *dlg-frame-prev-status* 'not-created)
(define *dlg-frame-next-status* 'not-created)

(define (dlg-frame-button-created? variable) (not (eq? variable 'not-created)))
(define (dlg-frame-button-disabled? variable) (eq? variable 'disabled))

(define (dlg-frame-mark-prev-button) (set! *dlg-frame-prev-status* 'created))
(define (dlg-frame-mark-next-button) (set! *dlg-frame-next-status* 'created))

(set-global! 'enable-prev (lambda()
			   (if (dlg-frame-button-created? *dlg-frame-prev-status*)
			     (prev-button enabled #t))
			     (set! *dlg-frame-prev-status*) 'enabled))

(set-global! 'enable-next (lambda ()
			   (if (dlg-frame-button-created? *dlg-frame-next-status*)
			     (next-button enabled #t))
			     (set! *dlg-frame-next-status*) 'enabled))

(set-global! 'disable-prev (lambda()
			    (if (dlg-frame-button-created? *dlg-frame-prev-status*)
			      (prev-button enabled #f))
			      (set! *dlg-frame-prev-status* 'disabled)))

(set-global! 'disable-next (lambda ()
			   (if (dlg-frame-button-created? *dlg-frame-next-status*)
			     (next-button enabled #f))
			     (set! *dlg-frame-next-status* 'disabled)))

(define (dlg-frame-prev-attr-enabled)
  (enabled (not (dlg-frame-button-disabled? *dlg-frame-prev-status*))))

(define (dlg-frame-next-attr-enabled)
  (enabled (not (dlg-frame-button-disabled? *dlg-frame-next-status*))))

;checks for global wizard parameters
(define *dlg-frame-global-passing* #t)
(define (dlg-frame-global-passing?) *dlg-frame-global-passing*)
(define (dlg-frame-global-set! value) (set! *dlg-frame-global-passing* value))

(define (dlg-frame-goto url)
  (next-button enabled #t)
  (prev-button enabled #t)
  ((from-context 'dialog) 'call on-before-goto url)
  (goto-in-widget page url)
  ((from-context 'dialog) 'call on-goto url))

;create internal page
(define (dlg-frame-make-page w h url)
  (goto-frame
    (id 'page (vbox
		(on-before-goto
		  (next-button enabled #t)
		  (prev-button enabled #t)
		  ((from-context 'dialog) 'call on-before-goto url))
		(on-goto
		  ((from-context 'dialog) 'call on-goto url))
		(relative-width w)
		(relative-height h)
		(load-url url)))))

(define (dlg-frame-prev-button-text)
  (if (dlg-frame-global-passing?)
    (_translation_ "Exit")
    (_translation_ "Prev")))

(define (dlg-frame-next-button-text)
  (if (dlg-frame-global-passing?)
    (_translation_ "Apply")
    (_translation_ "Next")))

;go previous step button
(define (dlg-frame-make-prev-button)
  (begin-1
    (id 'prev-button
	(button (dlg-frame-prev-button-text)
		(dlg-frame-prev-attr-enabled)
		(on-click
		  (if (dlg-frame-global-passing?)
		    (end-dialog)
		    (page 'call on-prev)))))
    (dlg-frame-mark-prev-button)))

;go next step button
(define (dlg-frame-make-next-button)
  (begin-1
    (id 'next-button
	(button (dlg-frame-next-button-text)
		(dlg-frame-next-attr-enabled)
		(on-click
		  (if (dlg-frame-global-passing?)
		    (page 'call on-apply)
		    (page 'call on-next)))))
    (dlg-frame-mark-next-button)))

;create bottom line with buttons
(define (dlg-frame-make-buttons)
  (hbox margin 2 spacing 1
	(dlg-frame-make-prev-button)
	(dlg-frame-make-next-button)))

;window with internal page and navigation buttons
(define (dlg-make-frame w h url)
  (vbox margin 1
    (dlg-frame-make-page w h url)
    (dlg-frame-make-buttons)))
