(use-modules (srfi srfi-1) (srfi srfi-13); to use in modules

	     (alterator str)
	     (alterator help)
	     (alterator gettext)
	     (alterator glob)
	     (alterator algo)
	     (alterator sandbox)
	     (alterator command)
	     
	     (alterator lookout woo)
	     (alterator lookout uri)
	     (alterator lookout context)
	     (alterator lookout ids)
	     (alterator lookout globals)
	     (alterator lookout events)
	     (alterator lookout goto)
	     (alterator lookout mapper)
	     (alterator lookout widgets)
	     (alterator lookout engine))

(define id set-id) ; guile suxx has same function, also cannot re-export

(define (dbus-handler sender destination interface dmember . args)
  (let ((current-dialog (from-context 'dialog)))
    (and current-dialog
	 (current-dialog 'call on-dbus
			 sender
			 destination
			 interface
			 dmember
			 args))))

(define-macro (declare-application-constructor func)
	      `(define lookout-make-application ,func))

(define-macro (declare-application-destructor func)
	      `(define lookout-delete-application ,func))

(define-macro (declare-application-executor func)
	      `(define lookout-exec-application ,func))

(define-macro (with-application-driver drv-path . instructions)
	      `(begin
		 (load ,drv-path)
		 (let ((app (lookout-make-application cmdline dbus-handler)))
		   ,@instructions
		   (lookout-delete-application app))))

;;;;;;;;;;;;wait-message support

(define (with-splash-message thunk)
  (let* ((splash (splashscreen))
	 (sp (cadr splash)))
    (with-changed-context 'splash sp
			  (dynamic-wind
			    (lambda()
			      ((caddr splash) #f)) ;initialize screen
			    thunk
			    (lambda()
			      (sp 'delete))))))

(define (splash-message msg)
  ((from-context 'splash) 'set 'message msg))

(define (splash-image img)
  ((from-context 'splash) pixmap img))


;run main dialog
(define (lookout-main filename)
 (with-mapper (load-mapper filename)
	      (lookout-exec-application)))

(define (lookout filename)
  (with-application-driver (string-append datadir "lookout-qt.scm")
    (lookout-main filename)))


