;description: support for old style woobus message passing

(define-module (alterator compat telegraph)
	       :use-module (ice-9 rdelim)
	       :use-module (alterator str)
	       :use-module (alterator compat command)
               :export (forward-address
			 backward-address
			 exit-address
			 message-accepted
			 end-of-message
			 unsupported-action
			 
			 wait-accept

			 write-bus
			 
			 current-ports
			 port-for-read
			 port-for-write
			 
			 message->commands
			 commands->message

			 read-bus-address
			 read-bus-message
			 read-bus
			 bus-query))


(define forward-address ">>")
(define backward-address "<<")
(define exit-address "xx")
(define message-accepted "vv")
(define end-of-message "^^")
(define unsupported-direction "<>")

(define (valid-addr? addr)
  (or (string=? addr forward-address)
      (string=? addr backward-address)
      (string=? addr exit-address)))

;all functions works with pair of ports: (for-read,for-write)
(define (current-ports) (cons (current-input-port) (current-output-port)))
(define (port-for-read ports) (car ports))
(define (port-for-write ports) (cdr ports))

;wait for accept or unsupported direction message
(define (wait-accept addr ports)
  (let ((read-port (port-for-read ports))
	(write-port (port-for-write ports)))
    (write-line addr write-port)
    (force-output write-port)
    (let loop ((line (read-line read-port)))
      (cond
	((eof-object? line) (error "unexpected eof"))
	((string=? line message-accepted) #t)
	((string=? line unsupported-direction) #f)
	(else (loop (read-line read-port)))))))

;write message to bus, return #t if message was accepted, #f otherwise
(define (write-bus addr message . args)
  (let* ((ports (if (null? args) (current-ports) (car args)))
	 (write-port (port-for-write ports))
	 (addr-line (sure-string addr)))
    (if (not (valid-addr? addr-line))
      (error "unsupported address type" addr-line)
      (and (wait-accept addr-line ports)
	   (begin (display message write-port) ;not use write-line to avoid extra #\newline symbols
		  (write-line end-of-message write-port)
		  (force-output write-port))))))

;TODO: don't forget about flushing output-port before sending accept
;(write-bus forward-address "message")
(define-macro (read-bus-address ports . args)
	      (let ((read-bus-loop (gensym))
		    (address (gensym)))
		`(let ,read-bus-loop ((,address (read-line (port-for-read ,ports))))
		   (cond
		     ((eof-object? ,address) (error "unexpected eof?"))
		     ,@(let loop ((res '())
				  (args args))
			 (if (null? args)
			   res
			   (let ((current (car args)))
			     (loop
			       (cons `((string=? (sure-string ,(car current)) ,address) 
				       ,@(cdr current)) res)
			       (cdr args)))))
		     (else
		       (write-line unsupported-direction (port-for-write ,ports))
		       (force-output (port-for-write ,ports))
		       (,read-bus-loop (read-line (port-for-read ,ports))))))))

(define (read-bus-message ports)
  (let ((read-port (port-for-read ports))
	(write-port (port-for-write ports)))
  (write-line message-accepted write-port)
  (force-output write-port)
  (let loop ((line (read-line read-port))
	     (res ""))
    (cond 
      ((eof-object? line) res)
      ((string=? line end-of-message) res)
      (else (loop (read-line read-port) (string-append res line (string #\newline))))))))

;read single message from single direction
(define (read-bus addr . args)
  (let ((ports (if (null? args) (current-ports) (car args))))
    (read-bus-address ports
		      (addr (read-bus-message ports)))))

;helper: convert bus message to set of commands
(define (message->commands msg)
  (with-input-from-string msg
    (lambda()
      (read-command-list))))

(define (commands->message cmds)
  (with-output-to-string
    (lambda ()
      (for-each (lambda (x) (write-command x)) cmds))))

;general woo query function
(define (bus-query . cmds)
  (write-bus '>> (commands->message cmds))
  (message->commands (read-bus '<<)))

