;decription: barnacle - old mariner (support for non-native woobus backend format)
;Note: in this version I've allowed to write to directories.
;Note: 'new action is same as 'write but with exitance checking
;TODO: add with-locked-file
(define-module (alterator ensign barnacle)
	       :use-module (ice-9 rdelim)
	       :use-module (srfi srfi-13)
	       :use-module (alterator pipe)
	       :use-module (alterator str)
	       :export (make-barnacle
			error-mariner))

;general helper functions

(define (type-from-answer answer)
  (let ((pos (string-index-right answer #\space)))
    (and pos (string-ref answer (+ 1 pos)))))

(define (name-from-answer answer)
  (substring answer 0 (or (string-index-right answer #\space) (string-length answer))))

(define (args-from-answer answer)
  (let ((pos (string-index answer #\:)))
    (if pos
      (cons (substring answer 0 pos)
	    (substring answer (+ pos 1) (string-length answer)))
      (error "wrong answer from backend, : separator not found" answer))))

;actions helpers

(define (do-read-list port)
  (read-fold (lambda (x res) (cons (list (name-from-answer x)) res)) '() port))

(define (do-read-info port)
  (read-fold (lambda (x res)
	       (let ((splited (args-from-answer x)))
		 (cons (string->symbol (car splited)) (cons (cdr splited) res)))) '() port))

;general wrapper for input functions
(define (do-in script object-name option proc)
  (define (combine process result)
    (cons (stop-process 'wait process) result))
  (let ((process (create-process 'read-only script option object-name)))
    (combine process (proc (cadr process)))))

(define (do-out script object-name . args)
  ;we have made a sigpipe protected output to backend, and , therefore, ignore possible problems 
  ;in backends. it's possible we will return a error message in the future
  (let ((outport (create-process 'write-only script "-w" object-name)))
    (catch #t
	   (lambda ()
	     (with-ignored-sigpipe
	       (lambda ()
		 (and (pair? args)
		      (display
			(string-join
			  (map (lambda (x)
				 (format #f "~A:~A~%" (car x) (cdr x)))
			       (car args))
			  "")
			(caddr outport)))
		 (stop-process 'wait outport))))
	   (lambda (key . args)
	     (stop-process 'terminate outport)))))

(define (do-delete script object-name)
  (and (not (zero? (stop-process 'wait (create-process 'read-only script "-d" object-name))))
       '(error "object was not deleted")))

(define (do-type script object-name)
  (if (string=? object-name "/")
    #\d
    (with-input-from-pipe `(,script "-t" ,object-name)
			  (lambda ()
			    (let ((answer (read-line)))
			      (if (eof-object? answer) #f (type-from-answer answer)))))))

;mariners
(define (error-mariner reason) (lambda args `(error ,reason)))

(define (barnacle script objects action)
  (let ((object-name (string-join (if (null? objects) '("/") objects) "/")))
    (case action
      ((list) (lambda args
		(let ((result (do-in script object-name "-l" do-read-list)))
		  (if (zero? (car result))
		    (cdr result)
		    '(error "list action failed")))))
      ((read) (lambda args
		(let ((result (do-in script object-name "-r" do-read-info)))
		  (if (zero? (car result))
		    (cdr result)
		    '(error "read action failed")))))
      ((write) (lambda args (and (not (zero? (apply do-out script object-name args)))
				 '(error "write action failed"))))
      ((new)  (lambda args (and (not (zero? (apply do-out script object-name args)))
				'(error "object was not created"))))
      ((delete) (lambda args (do-delete script object-name)))
      (else (error-mariner "unsupported action type")))))

;create new barnacle
(define (make-barnacle script)
  (lambda (objects action) (barnacle script objects action)))

