;description: dialog's context
;lookout context may contains:
; * current goto-frame
; * current stack of globals
; * current ids , etc.

(define-module (alterator lookout context)
	       :use-module (srfi srfi-1)
	       :use-module (alterator algo)
	       :export (lookout-context
			change-context
			from-context
			with-context
			with-changed-context))

(define lookout-context (make-fluid))
(fluid-set! lookout-context '())

(define (change-context name value)
  (alist-set name value (fluid-ref lookout-context)))

(define (from-context name)
  (cond-cdr (assq name (fluid-ref lookout-context))))

(define-macro (with-context ctxt . instructions)
	      `(with-fluids ((lookout-context ,ctxt))
			    ,@instructions))

(define-macro (with-changed-context name value . instructions)
	      `(with-fluids ((lookout-context (change-context ,name ,value)))
			    ,@instructions))
