(define-module (alterator lookout engine)
	       :use-module (alterator algo)
	       :use-module (alterator command)
	       :use-module (alterator lookout uri)
	       :use-module (alterator lookout context)
	       :use-module (alterator lookout globals)
	       :use-module (alterator lookout mapper)
	       :use-module (alterator lookout widgets)
	       :use-module (alterator lookout goto)
	       :use-module (alterator lookout ids)
	       :export (declare-main-widget
	       		lookout-main-widget
			
	       		run-dialog
			end-dialog

			load-url
			include-as-is
			include
			
			run-widget
			with-dialog
		
			make-relative-size
			relative-width
			relative-height))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(define-macro (with-dialog dlg . instructions)
	      `(with-changed-context 'dialog ,dlg
				     ,@instructions))
				     
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define lookout-main-widget #f)

(define-macro (declare-main-widget func)
	      `(set! lookout-main-widget ,func))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;create dialog object: widget with support of continuation and main subwidget
(define (make-dialog widget-constructor parent)
  (let ((widget (make-widget widget-constructor))
	(return-value #f))
    (widget 'new parent) ; all dialogs are without parents
    (lambda (command . args)
      (case command
	((start)  (set! return-value #f)
		  (widget 'start)
		  return-value)
	((stop)   (widget 'stop)
		  (if (not (null? args))
		    (set! return-value (car args))))
	(else (apply widget command args))))))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;run dialog with included widgets
(define-macro (run-widget widgetlist . args)
  (let ((parent (if (null? args) (from-context 'dialog) (car args))))
    `(let ((dlg (make-dialog lookout-main-widget ,parent)))
       (with-goto-frame dlg
			(begin-1
			  (with-dialog dlg
				       (with-ids (make-ids-holder)
						 (widget-parse-args dlg ,widgetlist)
						 ((from-context 'dialog) 'set-context
									 (fluid-ref lookout-context))
						 ((from-context 'dialog) 'start)))
			  (dlg 'delete))))))

;run new dialog via resolving it's uri
(define (run-dialog uri . args)
  (let ((parent (if (null? args) (from-context 'dialog) (car args)))
	(path (lookout-convert-uri uri)))
    (and (pair? path)
	 (with-globals (make-globals (cdr path))
		       (run-widget (load-widgets (car path)) parent)))))

;exit current dialog modal loop
(define (end-dialog . args) (apply (from-context 'dialog) 'stop args))

;load widget using appropriate url
(define (load-url . url)
  (let ((path (lookout-convert-uri url)))
    (and path
	 (lambda()
	       (command-for-each (lambda(name value) (set-global! name value)) path)
	       (load-widgets (car path))))))

(define (include-as-is url) ((load-url url)))
(define include load-widgets)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (make-relative-size value name source-widget)
  `(attr ,name
	 ,(quotient (* value (source-widget 'get name))
		    100)))

(define-macro (relative-width value . args)
  (let ((source-widget (if (null? args) (from-context 'dialog) (car args))))
    `(lambda() (make-relative-size ,value 'width ,source-widget))))

(define-macro (relative-height value . args)
  (let ((source-widget (if (null? args) (from-context 'dialog) (car args))))
    `(lambda() (make-relative-size ,value 'height ,source-widget))))

