;support for events in lookout interface descriptions
(define-module (alterator lookout events)
	       :use-module (srfi srfi-1)
	       :use-module (alterator algo)
	       :use-module (alterator lookout context)
	       :export (delayed
			 declare-event
			 make-event
			 make-event-holder))


;create delayed evaluation
(define-macro (delayed arglist . x) `(lambda (,@arglist) ,@x))

(define (make-event name delayed)
  `(event ,name ,delayed))

(define-macro (declare-event name . arglist)
	      (let ((args (gensym)))
		    `(define-macro (,name . ,args)
				   (let ((func-args ',arglist))
					   `(make-event ',',name (delayed (,@func-args) ,@,args))))))

(define (make-event-holder)
  (let ((eventmap '())
	(context '()))
    (lambda (command . args)
      (case command
	((call) (let ((founded (assq (sure-symbol (car args)) eventmap)))
		  (if founded
		    (with-context context ; run with saved context
				  (apply (cdr founded) (cdr args))) 
		     #t)))
	((add-event)  (let ((args (cdar args)))
			(set! eventmap (alist-set (car args)
						  (cadr args)
						  eventmap))))
	((delete-event) (for-each (lambda (x)
				    (set! eventmap (alist-delete! (sure-symbol x) eventmap)))
				  args))
	((set-context) (set! context (car args)))
	((get-context) context)
	((list) (map car eventmap))
	(else (error "unknown operation for event holder" command))))))

