;description: functions to change content of some widgets
;goto-in-widget replace content of selected widget
;goto function same as goto-in-widget, but works in some default goto-frame
;goto-frame lives in current lookout context

(define-module (alterator lookout goto)
	       :use-module (alterator algo)
	       :use-module (alterator lookout context)
	       :use-module (alterator lookout globals)
	       :use-module (alterator lookout uri)
	       :use-module (alterator lookout mapper)
	       :use-module (alterator lookout widgets)
	       :use-module (alterator lookout events)
	       :export (goto
			 goto-in-widget
			 
			 on-goto
			 on-before-goto
			 
			 goto-frame
			 with-goto-frame))

(declare-event on-goto url)
(declare-event on-before-goto url)

;pseudo widget to redirect current goto-frame to it's args
(define (goto-frame widget)
  (let ((pseudo (make-widget pseudo-widget)))
    (list
      'widget
      (make-widget pseudo-widget)
      (lambda (parent)
	(with-globals (extend-globals '()) ;parent widget has extended globals context now
		      (with-goto-frame (cadr widget)
				       (widget-parse-args parent (list widget))))
	pseudo))))

;replace content in some widget
(define (goto-in-widget widget url . args)
  (let ((path (lookout-convert-uri (cons url args))))
    ;work with widget's context and it's globals
    (with-context (widget 'get-context)
		 (and path
		      (widget 'delete-subwidgets)
		      (reset-globals! (cdr path))
		      (widget-parse-args widget (load-widgets (car path)))
		      (widget 'show-subwidgets)))))

(define (goto url . args)
  (let ((current-goto-frame (from-context 'goto-frame)))
    (current-goto-frame 'call on-before-goto url)
    (apply goto-in-widget current-goto-frame url args)
    (current-goto-frame 'call on-goto url)))

(define-macro (with-goto-frame frame . instructions)
	      `(with-changed-context 'goto-frame ,frame ,@instructions))

