(define-module (alterator lookout ids)
	       :use-module (srfi srfi-1)
	       :use-module (alterator algo)
	       :use-module (alterator lookout context)
	       :use-module (alterator lookout common)
	       :export (make-ids-holder
	       		set-id
	       		widget-id
			with-ids))

(declare-attribute widget-id)

(define (make-ids-holder)
  (let ((ids '()))
    (lambda (command . args)
      (case command
	((get) (cond-cdr (assq (car args) ids)))
	((set) (set! ids (acons (car args) (cadr args) ids)))
	((clear) (for-each
		   (lambda()
		     (eval `(define ,x #f) (current-module)))
		   (map car ids)))
	(else (error "unsupported operation for ids-holder" command))))))

(define (set-id name widget)
  (define (append-widget-id delayed-proc)
    (lambda (parent)
      (let ((widget (delayed-proc parent)))
	(widget widget-id name)
	widget)))
  ((from-context 'ids) 'set name (cadr widget))
  (eval `(define (,name . args) (apply ((from-context 'ids) 'get ',name) args))
	(current-module))
  (append (list-head widget 2)
	  (list (append-widget-id (list-ref widget 2)))))

(define-macro (with-ids ids . instructions)
  `(with-changed-context 'ids ,ids
  	,@instructions))

