;description: set of functions to work with dialog uris
(define-module (alterator lookout uri)
	       :use-module (srfi srfi-1)
	       :use-module (alterator algo)
	       :use-module (alterator lookout context)
	       :use-module (alterator lookout mapper)
	       :export (lookout-convert-path
			 lookout-convert-uri))

;convert path with filename with additional parameters
(define (lookout-convert-path uri)
  (let loop ((current-uri uri)
	     (result '()))
    (let ((path (mapper-view current-uri)))
      (and path
	   (case (list-ref path 2)
	     ((file) (append (list-tail path 4) result))
	     ((view) (loop (list-ref path 4) (append (list-tail path 5) result)))
	     (else (error "unknown action type")))))))

;uri with additional parameters
(define (lookout-convert-uri uri)
  (define (cond-append lst1 lst2)
    (and (pair? lst1) (append lst1 lst2)))
  (cond-append (lookout-convert-path (car uri)) (cdr uri)))
