#include <iostream>

#include <qtlook.hh>

static
DBusHandlerResult dbus_filter_func (DBusConnection *connection,DBusMessage *message,void *user_data)
{
	SCM args = SCM_EOL;

	args = scm_cons (str2scm(dbus_message_get_sender(message)), args);
	args = scm_cons (str2scm(dbus_message_get_destination(message)), args);
	args = scm_cons (str2scm(dbus_message_get_interface(message)), args);
	args = scm_cons (str2scm(dbus_message_get_member(message)), args);
	

	DBusMessageIter iter;
	dbus_message_iter_init (message, &iter);
	int count=0;
	do
	{
		switch (dbus_message_iter_get_arg_type (&iter))
		{
			case DBUS_TYPE_STRING:
				{
					const char *str;
          				dbus_message_iter_get_basic (&iter, &str); // -- new interface
					//str=dbus_message_iter_get_string(&iter); // -- old interface
					args = scm_cons (str2scm(str), args);
				}
				break;
			case DBUS_TYPE_INT32:
				{
					dbus_int32_t int32;
					dbus_message_iter_get_basic (&iter, &int32); // -- new interface
	  				//int32 = dbus_message_iter_get_int32 (&iter);// -- old inteface
					args = scm_cons (scm_int2num(int32), args);
				}
				break;
			case DBUS_TYPE_BOOLEAN:
				{
					dbus_bool_t b;
					dbus_message_iter_get_basic (&iter, &b); // -- new interface
	  				//b = dbus_message_iter_get_boolean (&iter);// -- old interface
					args = scm_cons (scm_uint2num(b), args);
				}
				break;
			default:
				args = scm_cons (SCM_UNSPECIFIED, args);
				break;
		}
		++count;
	}while (dbus_message_iter_next (&iter));

	scm_apply_0(qt_dbus_handler,scm_reverse(args));

	return DBUS_HANDLER_RESULT_HANDLED;
}


void init_qt_dbus(DBusBusType type)
{
	DBusConnection *connection;
	DBusError error;

	dbus_error_init (&error);
	connection = dbus_bus_get (type, &error);
	if (connection == NULL)
	{
		std::cerr<<"Failed to open connection to message bus:"<<
		((type == DBUS_BUS_SYSTEM) ? "system" : "session")
		<<"message:"<<error.message<<std::endl;
		dbus_error_free (&error);
		return; //ignore
	}
	dbus_bus_add_match(connection,"type='signal'",&error);   
	if (dbus_error_is_set (&error))
  	{
		std::cerr<<"Failed to add dbus match:"<<error.message<<std::endl;
		dbus_error_free (&error);
    		exit(1);
  	}

  	if (!dbus_connection_add_filter(connection, dbus_filter_func,NULL, NULL))
	{
		std::cerr<<"Failed to add dbus filter:"<<std::endl;
          	exit(1);
	}

	DBusQt::Connection   *conn = new DBusQt::Connection();//Note: we don't need to destruct this object
	conn->dbus_connection_setup_with_qt_main(connection);
}
