;Http interface driver for lookout

;;;;;;;;;;; TEMPORARY FOR DEBUG

;all this code will be rewritten to work with context

(define http-output (list #f))
(define (http-post-event . command)
  (append! http-output (list command)))

(define (make-http-id-generator)
  (let ((counter 0))
    (lambda ()
      (begin-1
	(string-append "w" (number->string counter))
	(set! counter (+ counter 1))))))
	
(define http-id-generator (make-http-id-generator))

;;;;;;;;;;; TEMPORARY FOR DEBUG


(define (make-http-simple-widget type)
  (lambda (eventdispatcher)
    (let ((id (http-id-generator))
	  (attributes '())
	  (events eventdispatcher))
      (lambda (command . args)
	;next process some simple actions
	(case command
	  ((get-http-id) id)
	  ((new) (http-post-event 'action "new"
				  'type type
				  'parent ((car args) 'get-http-id)))
	  ((set) (set! attributes (alist-set (sure-symbol (car args))
					     (cadr args)
					     attributes))
		 (http-post-event 'action "set"
				  'widget-id id
				  'attr (car args)
				  'value (cadr args)))
	  ((get) (cond-cdr (assq (sure-symbol (car args)) attributes)))
	  (else
	    (error "unknown operation for http widget")))))))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;driver description
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(declare-widget button (make-http-simple-widget "button") text)
(declare-widget edit (make-http-simple-widget "edit") text)
(declare-widget hbox (make-http-simple-widget "hbox"))

;wrapper over tab-panel
;insert widgets and generate also tab-panel attribute
(define (tab tab-id tab-label . widgets)
  (let ((vb (id tab-id (apply vbox widgets))))
   `(,vb ,(tab-panel tab-label (cadr vb)))))

(declare-application-constructor (lambda(cmdline dbus-handler) #t))
(declare-application-destructor (lambda(app) #t))
(declare-application-executor (lambda() #t))

(declare-main-widget (make-http-simple-widget "dialog"))

