(document:surround "/std/base")

(define (can-enable)
  (and (error-label visibility) (error-label visibility #f))
  (apply activity (and (not-empty-string? (passwd1 text))
                       (not-empty-string? (passwd2 text)))))

(groupbox "Root password"
          (layout-policy 100 80)
          (vbox
           (layout-policy 100 100)
           (hbox (layout-policy 100 -1)
                 (label "Type password:" (layout-policy 50 -1))
                 (document:id passwd1 (edit ""
                                            echo stars
                                            (layout-policy 50 -1)
                                            (on-change (can-enable)))))
           (hbox (layout-policy 100 -1)
                 (label "Re-type password:" (layout-policy 50 -1))
                 (document:id passwd2 (edit ""
                                            echo stars
                                            (layout-policy 50 -1)
                                            (on-change (can-enable)))))
           (document:id error-label (label "<p><b><font color=\"red\">Passwords mismatch try again</font><b></p>"
                                           (layout-policy 100 -1)
                                           visibility #f))))

(hbox
 (layout-policy 100 20)
 (document:id apply (button "Apply"
                            activity #f
                            (layout-policy 50 -1)
                            (on-click
                             (let ((p1 (passwd1 text))
                                   (p2 (passwd2 text)))
                             (if (string=? p1 p2)
                                 #t ;some actions
                                 (begin
                                   (passwd1 text "")
                                   (passwd2 text "")
                                   (can-enable)
                                   (error-label visibility #t)))))))

 (document:id cancel (button "Cancel" (layout-policy 50 -1)
                             (on-click (document:end)))))