(document:surround "/std/base")
(document:link to ("/std/functions") type insert)

(document:popup-size 400 200)

(define half-size (layout-policy 50 -1))

(define (username) (string-append "/users/" (name text)))

(define (edit-options)
  (list half-size
        (on-change
         (error-message visibility #f)
         (accept-button activity
                        (and (not-empty-string? (name text))
                             (not-empty-string? (passwd1 text))
                             (not-empty-string? (passwd2 text)))))))

(vbox (layout-policy 100 80)
      (hbox (layout-policy 100 25)
            (label "UserName:" half-size)
            (document:id name (edit "" (edit-options)) ))
      (hbox (layout-policy 100 25)
            (label "Comment:" half-size)
            (document:id gecos (edit "" (edit-options)) ))
      (hbox (layout-policy 100 25)
            (label "Type new password:" half-size)
            (document:id passwd1 (edit "" echo stars (edit-options)) ))
      (hbox (layout-policy 100 25)
            (label "Re-type new password:" half-size)
            (document:id passwd2 (edit "" echo stars (edit-options)) )))

(document:id error-message (label "" invisible (layout-policy 100 10)))

(hbox (layout-policy 100 10)
      (document:id accept-button (button "Accept user"
                                         half-size
                                         inactive
                                         (on-click (woo-catch
                                                    (lambda()
                                                      (apply woo-new (username)
                                                             'type "local"
                                                             'allow_su "no"
                                                             (fields->command passwd1 passwd2 gecos))
                                                      (document:end #t))
                                                    (lambda(reason)
                                                      (error-message text (bold-red reason))
                                                      (error-message visibility #t))))))
      (button "Cancel"
              half-size
              (on-click (document:end #f))))


