#!/usr/bin/guile -s
!#
(use-modules (ice-9 getopt-long)
	     (ice-9 debug)
	     
	     (alterator str)
	     (alterator http request))

(define datadir "/home/stas/Programming/TLA/alterator-httplook/common/")
(load (string-append datadir "lookout.scm"))

(define (write-text-html)
  (display "content-type: text/html") (newline)(newline))

(define (write-text-xml)
  (display "content-type: text/xml") (newline)(newline))

(define (write-unsupported)
  (write-text-html)
  (write-line "<html>
	      <body>
	      <p>GET method <b>are not supported</b> for this form</p>
	      </body>
	      </html>"))

(define (read-input)
  (call-with-output-file
    "/tmp/alterator-http.log"
    (lambda (port)
      (read-fold (lambda (line initial)
		   (write-line (string-append "line:" line) port))
		 ""))))

(define (write-content)
  (read-input)
  (write-text-xml)
  (with-application-driver
    (string-append datadir "lookout-http.scm")
    (with-mapper (load-mapper "/var/www/cgi-bin/simplemap.scm")
		 (let ((dlg (init-dialog '(/))))
		   (write-line "<alterator-answer>")
		   (map (lambda (cmd)
			  (display " ")(write-request cmd)(newline))
			(cdr http-output))
		   (write-line "</alterator-answer>")))))

(if (string=? (or (getenv "REQUEST_METHOD") "GET") "GET")
    (write-unsupported)
    (write-content))