;generic session's authentication laye
(define-module (alterator generic auth)
  :use-module (alterator algo)
  :use-module (alterator object)
  :use-module (alterator command)
  :use-module (alterator generic session)
  :use-module (alterator lookout popup)
  :use-module (alterator lookout document)
  :export (auth-generic-request
           auth-demo
	   auth-all))

(define (auth-demo user passwd)
  (and (string=? user "root")
       (string=? passwd "root")))

(define (auth-all user passwd) #t)

(define (auth-permission-denied)
  `(auth-answer content ((command action "forbidden"))))

(define (auth-permission-granted next content . args)
  `(auth-answer ,@args content ,(next content)))

;auth processing here
(define (auth-generic-request cmd checker next)
  (define-operation get-session-id)
  (define-operation start-thread)
  
  (let ((content (cond-cdr (command-arg-ref cmd 'content)))
	(user	 (cond-cdr (command-arg-ref cmd 'user)))
	(password (cond-cdr (command-arg-ref cmd 'password)))
	(lang (cond-cdr (command-arg-ref cmd 'language)))
	(session-id (cond-cdr (command-arg-ref cmd 'session-id))))
	
    (cond
      (session-id
       (let ((session (find-generic-session user session-id)))
         (if session
             (with-fluids ((generic-session session)) (auth-permission-granted next content))
             (auth-permission-denied))))

      ((and user password (checker user password))
       (with-fluids ((generic-session (make-generic-session user lang)))
                    (start-thread (fluid-ref generic-session)
                                  (lambda() (document:popup '/)))
                    (auth-permission-granted next content
                                             'user user
                                             'session-id (number->string (get-session-id (fluid-ref generic-session))))))

      (else (auth-permission-denied)))))
