;user's session in http look of alterator
(define-module (alterator generic dialog)
  :use-module (ice-9 threads)
  :use-module (srfi srfi-2)
  :use-module (alterator algo)
  :use-module (alterator str)
  :use-module (alterator object)
  :use-module (alterator command)
  :use-module (alterator generic session)
  :export (make-generic-dialog))

(define-operation get-widget)

;process incoming loop requests
(define (dialog-process-request dlg cmd)
  (and (command? cmd)
       (let ((action (cond-cdr (command-arg-ref cmd 'action))))
         (and action
              (case (sure-symbol action)
                ((get) (get-command dlg))
                ((event) (event-command dlg cmd))
                (else (error "unknown action" action)))))))

;process "get url" request
(define (get-command dlg)
  (define-operation bubbling)

  (bubbling dlg 're-create))

;invisible set for "event" request
(define (do-silent-process state-description)
  (define-operation silent-set)

  (define (process-value value)
   (if (string? value)
       (string-cut value #\;)
       (list value)))

  (and-let* ((id (sure-symbol (car state-description)))
             (widget (get-widget (fluid-ref generic-session) id))
             (attrs (cdr state-description)))
            (for-each (lambda (attr)
                        (let ((name (car attr))
                              (value (cdr attr)))
                          (or (null? value) (apply silent-set widget name (process-value value)))))
                      attrs)))

;process "event emit" request
(define (event-command dlg cmd)
  (define-operation call)
  
  (and-let* ((name (cond-cdr (command-arg-ref cmd 'name)))
             (id   (cond-cdr (command-arg-ref cmd 'widget-id)))
             (state (cond-cdr (command-arg-ref cmd 'state))))
            (for-each do-silent-process state);first process state here
	    (let ((widget (get-widget (fluid-ref generic-session) id)))
	     (and widget (call widget (sure-symbol name)))))) ;then run appropriate callback

;TODO: add bubbling for recreating: exec-dialog,also close-dialog to stop
(define (make-generic-dialog default id parent-id)
  (define-operation reset-output)
  (define-operation start-thread)
  (define-operation signal-output)
  (define-operation read-input)
  (define-operation get-id)
  
  (let ((do-loop #t)
        (session (fluid-ref generic-session)))
    (join
     default
     (object
      #f
      ((start self)
       (set! do-loop #t)
       (reset-output session);reset all previous messages in output queue
       (generic-post-event 'action "clear");clear window content
       (signal-output session)
       (let modal-loop ()
         (let* ((msg (read-input session)))
           (and msg (dialog-process-request self msg)))
         (and do-loop (begin (signal-output session) (modal-loop)))))
      ((stop self)
       (reset-output session);reset all previous messages in output queue
       (generic-post-event 'action "clear");clear window content
       (set! do-loop #f))))))
