;Http interface driver for lookout

(define-module (alterator generic widgets)
  :use-module (srfi srfi-1)
  :use-module (srfi srfi-2)
  :use-module (srfi srfi-13)
  :use-module (alterator str)
  :use-module (alterator algo)
  :use-module (alterator object)
  :use-module (alterator generic dialog)
  :use-module (alterator generic session)
  :use-module (alterator generic auth)

  :export (make-generic-widget
           make-generic-default-widget
	   make-generic-listbox))
           
;;;;;;;;;;;;;;;;;;;;;;;;;; widget engines
(define (extract-real-id x)
  (define-operation get-id)
  (if (object? x) (get-id x) x))

(define (extract-all-real-ids lst)
  (map extract-real-id lst))

;for widgets: we save widgets as a properties: send to http as an ids,or as a real ids
(define (make-generic-default-widget id parend-id)
  (define-operation silent-set)
  

  (let ((attributes '())
        (apriori-attributes '((activity . (#t))
                              (visibility . (#t)))))
    (object
      #f
      ((set self name . value)
       (let ((value (extract-all-real-ids value)))
         (apply silent-set self name value)
         (generic-post-event 'action "set"
                          'widget-id id
                          'attr name
                          'value (string-join (map sure-string value) ";"))))
      ((silent-set self name . value)
       (let ((value (extract-all-real-ids value)))
         (set! attributes (alist-set
                           (sure-symbol name)
                           value
                           attributes))))
      ((get self name)
       (cond ((or (assq (sure-symbol name) attributes)
                  (assq (sure-symbol name) apriori-attributes)) =>
                  (lambda (x)
                    (let ((x  (cdr x)))
                      (if (= (length x) 1)
                          (car x)
                          x))))
	     (else #f)))
      ((bubbling self subcommand . args)
       (case subcommand
	 ((re-create)
	  (for-each (lambda (attr)
		      (let ((name (car attr))
			    (value (cdr attr)))
                        (and (not (eq? name 'widget-id))
                             (generic-post-event 'action "set"
                                              'widget-id id
                                              'attr name
                                              'value (string-join (map sure-string
                                                                       value) ";")))))
		    attributes)))))))


(define (notify-add-item id item)
  (generic-post-event 'action "set"
                      'widget-id id
                      'attr "append-item"
                      'value (string-append (car item) ";" (cdr item))))

(define (make-generic-listbox-setter id items)
  (define-operation append-item)
  (define-operation remove)
  (define-operation set)
  
  (object
   #f
   ((items self itemlist)
    (remove self 'all)
    (map (lambda (item) (append-item self item)) itemlist))
   ((append-item self item)
    (cell-set! items (append (cell-ref items) (list (if (pair? item)
                                        ;made copies to avoid conflicts in future changes
                                        ;throw set-car! and set-cdr!
                                                        (cons (car item) (cdr item))
                                                        (cons item "")))))
    (notify-add-item id (car (last-pair (cell-ref items)))))
   ((remove self . range) (if (eq? (car range) 'all)
                              (begin
                                (cell-set! items '())
                                (generic-post-event 'action "set"
                                                 'widget-id id
                                                 'attr "remove-item"
                                                 'value "all"))
                              (for-each (lambda(number)
                                          (cell-set! items (list-remove (cell-ref items) number))
                                          (generic-post-event 'action "set"
                                                           'widget-id id
                                                           'attr "remove-item"
                                                           'value (sure-string number)))
                                        (reverse (extract-range range)))))
   ((item-pixmap self pixmap . range) (for-each (lambda(number)
                                                  (set-cdr! (list-ref (cell-ref items) number) pixmap)
                                                  (generic-post-event 'action "set"
                                                                   'widget-id id
                                                                   'attr "item-pixmap"
                                                                   'value (string-append
								           pixmap
									   ";"
								           (sure-string number))))
                                                (extract-range range)))
   ((item-text self text . range) (for-each (lambda (number)
                                              (set-car! (list-ref (cell-ref items) number) text)
                                              (generic-post-event 'action "set"
                                                               'widget-id id
                                                               'attr "item-text"
                                                               'value (string-append
							               text
								       ";"
							               (sure-string number))))
                                            (extract-range range)))))

(define (make-generic-listbox-getter id items default-widget)
  (define-operation get)
  (define-operation item-text)
  (object
   #f
   ((count self) (length (cell-ref items)))
   ((text self) (item-text self (get default-widget 'current)))
   ((item-text self number) (car (list-ref (cell-ref items) number)))
   ((item-pixmap self number) (cdr (list-ref (cell-ref items) number)))))

(define (make-generic-listbox id parent-id)
  (define-operation set)
  (define-operation get)
  (define-operation bubbling)
  
  (let* ((items (make-cell '()))
         (default-widget (make-generic-default-widget id parent-id))
         (http-listbox-setter (make-generic-listbox-setter id items))
         (http-listbox-getter (make-generic-listbox-getter id items default-widget)))
    (join
     (object
      #f
      ((set self value . args)
       (let ((op (select-operation generic-listbox-setter value)))
         (if (procedure? op)
             (apply op generic-listbox-setter args)
             (apply set default-widget value args))))
      ((get self value . args)
       (let ((op (select-operation generic-listbox-getter value)))
         (if (procedure? op)
             (apply op generic-listbox-getter args)
             (apply get default-widget value args))))
      ((bubbling self subcommand . args)
       (case subcommand
         ((re-create)
          (generic-post-event 'action "set"
                           'widget-id id
                           'attr "remove-item"
                           'value "all")
          (for-each (lambda (item) (notify-add-item id item)) (cell-ref items))))
       (apply bubbling default-widget subcommand args)))
      default-widget)))

(define (make-generic-widget type . rest)
  (define-operation get-widget)
  (define-operation add-widget)
  (define-operation remove-widget)
  (define-operation make-widget-id)
  (define-operation list-events)
  (define-operation bubbling)
  
  (lambda (eventholder parent-widget)
    
    (define (register-events id)
      (for-each (lambda (x)
		  (generic-post-event 'action "create-event"
				   'widget-id id
				   'value x))
		(list-events eventholder)))

    (let* ((id (make-widget-id (fluid-ref generic-session)))
	  (parent-id (or (and parent-widget (get-widget parent-widget)) ""))
	  (mixed-widget  (if (null? rest) (make-generic-default-widget id parent-id) ((car rest) id parent-id))))

      (generic-post-event 'action "new" 'widget-id id 'type type 'parent parent-id)
      
      (join
	(object
	  #f
	  ((get-widget self) id)
	  ((post-new self super . args)
           (add-widget (fluid-ref generic-session) id super)
	   (register-events id))
	  ((delete self)
           (remove-widget (fluid-ref generic-session) id)
           (generic-post-event 'action "delete" 'widget-id id))
	  ((bubbling self subcommand . args)
	   (case subcommand
	     ((re-create)
	      (and id
		   (begin
		     (generic-post-event 'action "new"
				      'widget-id id
				      'type type
				      'parent parent-id)
		     (bubbling mixed-widget subcommand)
		     (register-events id)))))))
	mixed-widget))))


