;generic widgets based interface - woobus module
(define-module (alterator lookout)

  ;common modules
  :use-module        (alterator str)
  :use-module	     (alterator object)
  :use-module	     (alterator help)
  :use-module	     (alterator gettext)
  :use-module	     (alterator glob)
  :use-module	     (alterator algo)
  :use-module	     (alterator sandbox)
  :use-module	     (alterator command)
	     
  ;lookout modules
  :use-module	     (alterator lookout common)
  :use-module	     (alterator lookout woo)
  :use-module	     (alterator lookout context)
  :use-module	     (alterator lookout globals)
  :use-module	     (alterator lookout events)
  :use-module	     (alterator lookout goto)
  :use-module	     (alterator lookout atlas)
  :use-module	     (alterator lookout widgets)
  :use-module	     (alterator lookout popup)
  :use-module	     (alterator lookout document)

  ;generic modules
  :use-module	     (alterator generic widgets)
  :use-module	     (alterator generic dialog)
  :use-module	     (alterator generic auth)
  :use-module	     (alterator generic session)
  
  :export (lookout
  
  ;also widgets and events for correct eval
  on-click
  on-double-click
  on-change
  on-return
  on-select
  on-toggle
  on-destroy
  
  button
  label
  edit
  hbox
  vbox
  groupbox
  textbox
  tab-page
  tabbox
  tab
  checkbox
  listbox
  combobox
  ))


;;;;;;;;;;;;;;;common declarations of generic widgets
(declare-event-callback on-click)
(declare-event-callback on-double-click)
(declare-event-callback on-change)
(declare-event-callback on-return)
(declare-event-callback on-select)
(declare-event-callback on-toggle)
(declare-event-callback on-destroy)

(declare-widget button (make-generic-widget "button") text)
(declare-widget label (make-generic-widget "label") text)
(declare-widget edit (make-generic-widget "edit") text)
(declare-widget hbox (make-generic-widget "hbox"))
(declare-widget vbox (make-generic-widget "vbox"))
(declare-widget groupbox (make-generic-widget "groupbox") title)
(declare-widget textbox (make-generic-widget "textbox") text)
(declare-widget tab-page (make-generic-widget "tab-page") text)
(declare-widget tabbox (make-generic-widget "tabbox"))
(declare-widget checkbox (make-generic-widget "checkbox") text)
(declare-widget listbox (make-generic-widget "listbox" make-generic-listbox))
(declare-widget combobox (make-generic-widget "combobox" make-generic-listbox))

;wrapper over tab-page
(define-macro (tab <name> . <args>)
  `(tab-page ,<name> (vbox . ,<args>)))

(declare-root-widget (make-generic-widget "vbox"))
(declare-popup-widget (make-generic-widget "dialog" (lambda (id parent-id)
                                                      (make-generic-dialog
                                                       (make-generic-default-widget id parent-id)
                                                       id
                                                       parent-id))))

(declare-lang-selector (lambda()
                         (define-operation get-lang)
                         (list (or (get-lang (fluid-ref generic-session)) "en"))))




;main entry point
;get next command from upper level pass it to engine
;process only single command here
(define (lookout-main cmd-pair next auth-checker)
    (define-operation write-input)
    (define-operation read-output)
    
    (let ((result (auth-generic-request (cadr cmd-pair)
                       auth-checker
                       (lambda(msg)
                          (let ((session (fluid-ref generic-session)))
                                (write-input session msg)
                                (read-output session))))))
	(cons (car cmd-pair) result)))

(define (lookout auth-checker)
    (lambda (cmd-pair next)
            (with-fluids ((woo-gate next))
      	    	(lookout-main cmd-pair next auth-checker))))