(define-module (alterator transport server-socket)
    :use-module (ice-9 rdelim)
    :use-module (alterator object)
    :export(server-socket))

(define (close-and-throw s args)
  (close s)
  (apply throw 're-send-system-error args))


(define (create-and-bind-socket socket-name)
 (define (bind-and-return s)
   (bind s AF_UNIX socket-name) s)

  (let ((s (socket PF_UNIX SOCK_STREAM 0)))
    (catch 'system-error
      (lambda() (bind-and-return s))
      (lambda(key . args)
        (if (and (string? (car args)) (string=? (car args) "bind")
                 (number? (car (cadddr args))) (= (car (cadddr args)) 98))
            (catch 'system-error
              (lambda ()
                (connect s AF_UNIX socket-name)
                (close-and-throw s args)); oops ... something uses this socket
              (lambda(key2 . args2) ;ok remove and rebind
                (delete-file socket-name)
                (bind-and-return s)))
            (close-and-throw s args))))))

(define (make-server-socket socket-name)
    (let ((s (create-and-bind-socket socket-name)))
      (listen s 10)
      (chmod socket-name #o666) ; temporary hack, will be replaced with chown and chmod to group
      (object
       #f
       ((close self) (close s) (delete-file socket-name))
       ((get-connection self) (car (accept s))))))
    
;create new server
(define (main-server-socket cmd-pair next . args)
  (define-operation get-connection)

  (let* ((socket-name (if (null? args) "/tmp/alterator-sock" (car args)))
         (server-socket (make-server-socket socket-name)))
    (write-line "listen for connections ...")
    (let listen-loop ((c (get-connection server-socket)))
      (write-line "accepting connection and process commands")
      (let command-loop ((cmd (read c)))
        (and (not (eof-object? cmd))
	     (let ((answer (next (cons cmd (list cmd)))))
             	  (write (cdr answer) c))
             (command-loop (read c))))
      (close c)
      (write-line "go to next processing")
      (listen-loop (get-connection server-socket)))))
    
(define (server-socket . args)
  (lambda (cmd-pair next)
    (apply main-server-socket cmd-pair next args)))
