(define-module (alterator generic xml)
  :use-module (alterator command)
  :use-module (alterator str)
  :use-module (alterator algo)
  :export (command->xml
           xml-string-quote
           auth->xml))

(define (xml-string-quote str)
  (string-quote (lambda (ch)
		  (case ch
		    ((#\&) "&amp;")
		    ((#\') "&apos;")
		    ((#\") "&quot;")
		    ((#\<) "&lt;")
		    ((#\>) "&gt;")
		    (else (string ch))))
		str))

(define (command->xml cmd)
  (string-append
   (apply string-append
          (format #f " <~A " (xml-string-quote (sure-string (command-name cmd))))
          (command-fold
	   (lambda (name value initial)
             (append initial
                     (list
                      (format #f " ~A=~S"
                              name
                              (xml-string-quote (sure-string value))))))
           '()
           cmd))
   "/>"
   (string #\newline)
   ))

(define (auth->xml cmd)
  (let ((user (cond-cdr (command-arg-ref cmd 'user)))
        (session-id (cond-cdr (command-arg-ref cmd 'session-id)))
        (content (cond-cdr (command-arg-ref cmd 'content))))
    (string-append
     (apply
      string-append
      (apply
       string-append
       "<auth-answer"
       (delq #f
             (list
             (and user (format #f " user=~S" (xml-string-quote user)))
             (and session-id (format #f " session-id=~S" (xml-string-quote session-id))))))
      ">"
      (string #\newline)
      (map command->xml content))
     "</auth-answer>"
     (string #\newline))))
