;input/output of interface commands throw cgi interface
(define-module (alterator http request)
	       :use-module (alterator command)
	       :use-module (alterator str)
	       :export (write-request))

(define (xml-string-quote str)
  (string-quote (lambda (ch)
		  (case ch
		    ((#\&) "&amp;")
		    ((#\') "&apos;")
		    ((#\") "&quot;")
		    ((#\<) "&lt;")
		    ((#\>) "&gt;")
		    (else (string ch))))
		str))


(define (write-request cmd . rest)
  (and (pair? cmd)
       (let ((port (if (null? rest) (current-output-port) (car rest))))
	 (display (format #f "<~A "(command-name cmd)) port)
	 (command-for-each 
	   (lambda (name value)
	     (display (format #f "~A=\"~A\" "
			    name
			    (xml-string-quote (sure-string value)))
		    port))
	   cmd)
	 (display "/>"))))

