(define-module (alterator transport pipe-channel)
  :use-module (alterator pipe)
  :use-module (alterator generic xml)
  :export (pipe-in))

(define (pipe-in-main cmd-pair next ports)
  (let* ((cmd (read (port-for-read ports)))
         (ans (or (eof-object? cmd)
                  (cdr (next (cons cmd (list cmd)))))))
    (and (eof-object? cmd) (quit))
    (with-ignored-sigpipe
     (lambda()
       (and (pair? ans)
            (let ((out (port-for-write ports))) 
              (display (auth->xml ans) out)
              (display "--stop--" out)
              (newline out))))))
  (pipe-in-main cmd-pair next ports))
    
(define (pipe-in command . args)
  (let ((ports (apply create-process 'read-write  command args)))
    (lambda (cmd-pair next)
      (pipe-in-main cmd-pair next ports))))

