(define-module (alterator transport server-socket)
    :export(client-socket))

;create new server
(define (main-server-socket cmd-pair next socket-name)
  (let ((s (client-socket (socket PF_UNIX SOCK_STREAM 0))))
    (connect s AF_UNIX socket-name)
    (write (cdr cmd-pair) s)
    (let ((answer (read s)))
      (cons answer (list answer)))))

(define (client-socket . args)
  (let ((socket-name (if (null? args) "/tmp/alterator-sock" (car args))))
    (lambda (cmd-pair next)
      (main-client-socket cmd-pair next socket-name))))
