;user's session in generic look of alterator
(define-module (alterator generic background)
  :use-module (ice-9 threads)
  :use-module (srfi srfi-1)

  :use-module (alterator generic session)
  :export (in-background
           generic-register-thread
           generic-unregister-thread))

(define thread-mutex (make-mutex))
(define thread-list '())

;id generator
(define id-generator (let ((count 0)
                           (m (make-mutex)))
                       (lambda ()
                         (with-mutex m
                                     (set! count (+ 1 count))
                                     count))))

;thread registrator
;to avoid races: add/remove vs. remove/add both registrator and de-registrator works in counterphase
(define (generic-register-thread id thread)
  (with-mutex thread-mutex
              (if (assv id thread-list)
                  (begin (generic-timer-del)
                         (set! thread-list (alist-delete id thread-list)))
                  (begin (generic-timer-add)
                         (set! thread-list (acons id thread thread-list))))))

;thread de-registrator
(define (generic-unregister-thread id)
  (with-mutex thread-mutex
              (if (assv id thread-list)
                  (begin (generic-timer-del)
                         (set! thread-list (alist-delete id thread-list)))
                  (begin (generic-timer-add)
                         (set! thread-list (acons id 'fake thread-list))))))


;to avoid problems with garbage collector we register all created threads in some general list
(define (in-background func)
  (let ((id (id-generator)))
    (generic-register-thread id (generic-thread (lambda()
                                                   (func)
                                                   (generic-unregister-thread id))))))
