;http session's authentication laye
(define-module (alterator http auth)
  :use-module (alterator algo)
  :use-module (alterator object)
  :use-module (alterator command)
  :use-module (alterator http session)
  :use-module (alterator lookout popup)
  :use-module (alterator lookout document)
  :export (auth-http-request))

;demo authorizarion
(define (auth-user user passwd)
  (and (string=? user "root")
       (string=? passwd "root")))

(define (auth-permission-denied)
  `(auth-answer content ((command action "forbidden"))))

(define (auth-permission-granted next content . args)
  `(auth-answer ,@args content ,(next content)))

;auth processing here
(define (auth-http-request cmd next)
  (define-operation get-session-id)
  (define-operation start-thread)
  
  (let ((content (cond-cdr (command-arg-ref cmd 'content)))
	(user	 (cond-cdr (command-arg-ref cmd 'user)))
	(password (cond-cdr (command-arg-ref cmd 'password)))
	(lang (cond-cdr (command-arg-ref cmd 'language)))
	(session-id (cond-cdr (command-arg-ref cmd 'session-id))))

    (cond
      (session-id
       (let ((session (find-http-session user session-id)))
         (if session
             (with-fluids ((http-session session)) (auth-permission-granted next content))
             (auth-permission-denied))))

      ((and user password (auth-user user password))
       (with-fluids ((http-session (make-http-session user lang)))
                    (start-thread (fluid-ref http-session)
                                  (lambda() (document:popup '/)))
                    (auth-permission-granted next content
                                             'user user
                                             'session-id (get-session-id (fluid-ref http-session)))))

      (else (auth-permission-denied)))))
