#!/usr/bin/guile -s
!#
(use-modules (ice-9 getopt-long)
	     (ice-9 debug)
	     
	     (alterator str)
	     (alterator algo)
	     (alterator http request))

(define *socket-name* "/tmp/alterator-sock")

(define (write-text-html)
  (display "content-type: text/html") (newline)(newline))

(define (write-text-xml)
  (display "content-type: text/xml") (newline)(newline))

(define (write-unsupported)
  (write-text-html)
  (write-line "<html>
	      <body>
	      <p>GET method <b>are not supported</b> for this form</p>
	      </body>
	      </html>"))

(define (communicate)
  (let ((s (socket PF_UNIX SOCK_STREAM 0)))
    (connect s AF_UNIX *socket-name*)
    (write (read) s)
    (begin-1
      (read s)
      (close-port s))))

(define (write-content)
  (let ((answer (communicate)))
    (write-text-xml)
    (write-line "<alterator-answer>")
    (map (lambda (cmd)
	   (display " ")(write-request cmd)(newline))
	 answer)
    (write-line "</alterator-answer>")))

(setlocale LC_ALL "")

(if (string=? (or (getenv "REQUEST_METHOD") "GET") "GET")
    (write-unsupported)
    (write-content))

