(define-operation value-of (lambda(obj) obj))
(define-operation register #f)


(define (get-rest-args arglist)
  (cond
   ((symbol? arglist) arglist)
   (else (cdr (last-pair arglist)))))

(define (get-first-args arglist)
  (cond
   ((symbol? arglist) '())
   (else (let loop ((result '())
                    (lst arglist))
            (if (pair? lst)
                (loop (append1 result (car lst)) (cdr lst))
                result)))))

(define-macro (:lambda <arglist> . <body>)
  (let ((value (gensym))
        (obj (gensym))
        (args-first (get-first-args <arglist>))
        (args-rest  (get-rest-args <arglist>)))
    `(lambda ,<arglist>
       (let* ((,value (make-value))
              (,obj
               (join
                (lambda()
                  (,value (let ,(append
                                 (map (lambda(arg) `(,arg (value-of ,arg))) args-first)
                                 (if (null? args-rest) '()
                                     `((,args-rest (map value-of ,args-rest)))))
                            ,@<body>)))
                ,value)))
         ,@(map (lambda (arg) `(register ,arg ,obj)) args-first)
         ,@(if (null? args-rest) '() `((map (lambda (arg) (register arg ,obj)) ,args-rest)))
         (,obj)
         ,obj))))


;(define :string-append (:lambda args (apply string-append args)))
;(define :+ (:lambda args (apply + args)))
