(define-operation set-value! #f)
(define-operation value-of (lambda(obj) obj))
(define-operation register #f)

(define (:same arg1 arg2 . args)
  (let ((args (append (list arg1 arg2) args)))
    (let* ((value (make-value))
           (unlocked #t) ;lock during balancing to avoid back propagation to itself
           (make-balancer (lambda(arg)
                            (lambda()
                              (and unlocked
                                   (begin (set! unlocked #f)
                                          (let ((new-value (value-of arg)))
                                            (for-each (lambda (arg) (and (procedure? arg) (arg new-value)))
                                                      (delq arg args)))
                                          (set! unlocked #t))))))
           (obj (join
                 (object
                  (lambda (new-value)
                    (arg1 new-value) ;initiate balansing process
                    (value new-value))) ;run propagation
                 value)))
      (map (lambda(arg) (register arg (make-balancer arg))) args) ;register balancer engines
      (obj (value-of arg1))
      obj)))

  