(use-modules  (alterator object) (alterator algo))

;TODO: implement childlist using weak hashes
(define (make-node)
  (let ((childs '()))
    (object
     #f
     ((propagate self)
      (for-each (lambda(obj) (obj)) childs))
     ((register self obj)
      (set! childs (append1 childs obj)))
     ((childs self) childs))))

(define-operation value-of (lambda(obj) obj))
(define-operation register #f)
(define-operation propagate)

(define (make-value . value)
  (let ((value (if (null? value) (if #f #f) (car value)))
        (node (make-node)))
    (join
     (object
      (lambda(new-value)
        (set! value new-value)
        (propagate node))
      ((value-of self) value))
     node)))

(define (get-rest-args arglist)
  (cond
   ((symbol? arglist) arglist)
   (else (cdr (last-pair arglist)))))

(define (get-first-args arglist)
  (cond
   ((symbol? arglist) '())
   (else (let loop ((result '())
                    (lst arglist))
            (if (pair? lst)
                (loop (append1 result (car lst)) (cdr lst))
                result)))))

(define-macro (:lambda <arglist> . <body>)
  (let ((value (gensym))
        (obj (gensym))
        (args-first (get-first-args <arglist>))
        (args-rest  (get-rest-args <arglist>)))
    `(lambda ,<arglist>
       (let* ((,value (make-value))
              (,obj
               (join
                (lambda()
                  (,value (let ,(append
                                 (map (lambda(arg) `(,arg (value-of ,arg))) args-first)
                                 (if (null? args-rest) '()
                                     `((,args-rest (map value-of ,args-rest)))))
                            ,@<body>)))
                ,value)))
         ,@(map (lambda (arg) `(register ,arg ,obj)) args-first)
         ,@(if (null? args-rest) '() `((map (lambda (arg) (register arg ,obj)) ,args-rest)))
         (,obj)
         ,obj))))

(define :string-append (:lambda args (apply string-append args)))
(define :+ (:lambda args (apply + args)))
