(use-modules (srfi srfi-1))


(define (compose . args)
  (fold-right (lambda(x y)
                (if (eq? y 'first)
                    x
                    (x y)))
        'first
        args))

(define (auto-curry proc deep . saved-args)
  (lambda args
    (let ((len (length args)))
      (if (< len deep)
          (apply auto-curry proc (- deep len) (append saved-args args))
          (apply proc (append saved-args args))))))

(define (symbol-append . args)
  (string->symbol (apply string-append
                         (map symbol->string args))))



(define-macro (define-auto-curry-of <name>)
  `(define ,(symbol-append 'curry: <name>)
     (auto-curry ,<name>
                 (car (procedure-property ,<name>
                                          'arity)))))

(define-auto-curry-of map)
(define-auto-curry-of delete)

(write (compose (curry:delete -1) (curry:map -) (list 1 2 3)))
(newline)

