; backend3 - improved external backend system, next generation of barnacle

;process is dead try to restart it
(define (restart process status script)
  (format #t "restarting backend...~%")
  (if (status:exit-val status)
      (begin (cell-set! process (create-process 'read-write script))
             #f)
      (begin (cell-set! process #f)
             '(error "process was abnormally terminated"))))

;sure that process exists
(define (sure process script)
  (if (cell-ref process)
      (let ((result (waitpid (car (cell-ref process)) WNOHANG)))
        (if (zero? (car result))
            #f
            (restart process (cdr result) script)))
      '(error "process was abnormaly terminated")))

(define (communicate process objects options)
  (let ((i-port (port-for-read process))
        (o-port (port-for-write process)))
    ;first output options to process
    (catch #t
      (lambda()
        (with-ignored-sigpipe
         (lambda()
           (display "_message:begin" o-port)
           (newline o-port)
           (display "_objects:" (if (null? objects) "/" (string-join objects "/")) o-port)
           (newline o-port)
           (for-each (lambda (option)
                       (display (car option) o-port)
                       (display ":" o-port)
                       (display (cdr option) o-port)
                       (newline))
                     options)
           (display "_message:end" o-port)
           (newline o-port))))
      (lambda (key . args)
        '(error "unable to write to backend")))
    ;then read answer
    (catch #t
      (lambda() (let ((answer (read i-port)))
                  (if (eof-object? answer)
                      '(error "unexpected eof from backend")
                      answer)))
      (lambda (key . args) '(error "malformed output from backend")))))

   
(define (make-backend3 script)
  (let ((process (create-process 'read-write script)))
     (lambda (self objects options)
       (or (sure process script)
           (communicate process objects options)))))
