(document:surround "/std/frame")
(document:link to ("/std/functions") type insert)

(define (users)
  (woo-catch
   (lambda() (woo-read-names "/users" (woo-list "/users")))
   (lambda(reason) '())))

(define (update-users)
  (let ((users (users)))
  
    (do-edit activity #f)
    (do-delete activity #f)
    
    (userlist items users)
    (or (null? users)
        (begin (userlist current 0)
               (userlist 'call 'on-select)))))

(define (user name)
  (woo-first-command (woo-read (string-append "/users/" name))))

(define (current-user)
  (string-append "/users/" (userlist text)))

(define (change-general-options)
  (apply woo-write (current-user)
                   'type "local"
                   (fields->command uid gid home gecos)))

(define (change-chpasswd)
  (let ((p1 (passwd1 text))
        (p2 (passwd2 text)))
    (cond
     ;all fields not-empty
     ((and (not-empty-string? p1)
           (not-empty-string? p2))
      (apply woo-write (current-user)
                       'type "local"
		       (fields->command passwd1 passwd2)))
     ;only one field ready
     ((or (not-empty-string? p1)
          (not-empty-string? p2))
      (throw 'woo-error "You should type new password twice")))))
                 
(define (write-error reason)
  (error-message text (bold-red reason))
  (error-messsage visibility #t))

(define (change-all)
  (woo-catch
   (lambda()
     (change-general-options)
     (change-chpasswd)
     #t)
   (lambda(reason)
     (passwd1 text "")
     (passwd2 text "")
     (write-error reason)
     #f)))
       
(define (fill-general-options)
  (command->fields (user (userlist text))
                   uid gid home gecos))

(define (fill-chpasswd)
  (passwd1 text "") (passwd2 text ""))

(define (fill-all)
  (fill-general-options)
  (fill-chpasswd)
  (and (error-message visibility) (error-message visibility #f)))

(define (toggle-general-options state)
  (for-each (lambda(x) (x activity state)) (list uid gid home gecos)))

(define (toggle-chpasswd state)
  (for-each (lambda(x) (x activity state)) (list passwd1 passwd2)))

(define (toggle-all state)
  (toggle-general-options state)
  (toggle-chpasswd state)
  (or state (and (error-message visibility) (error-message visibility #f))))

(define (edit-options)
  (list inactive
       (on-change
         (and (error-message visibility) (error-message visibility #f)))))

(define *initial-users* (users));initial list of users

;edit-users layout
(define (make-viewer)
  (hbox (layout-policy 100 80)
   (document:id userlist
                (listbox (items *initial-users*)
                         (layout-policy 30 100)
                         (on-select (do-edit activity #t)
                                    (do-delete activity #t)
                                    (fill-all))))
   (vbox (layout-policy 80 100)
         (tabbox
          (layout-policy 100 70)
          (document:id general-options
                       (tab "General Options" expanded
		       	    margin 10
                            (layout-policy 100 100)
                            (vbox (layout-policy 80 -1)
			    	spacing 2
				margin 2
                             (hbox (layout-policy 100 20)
                                   (label "UID:" (layout-policy 50 -1))
                                   (document:id uid (edit "some uid" (edit-options) (layout-policy 50 -1))))
                             (hbox (layout-policy 100 20)
                                   (label "GID:" (layout-policy 50 -1))
                                   (document:id gid (edit "some gid" (edit-options) (layout-policy 50 -1))))
                             (hbox (layout-policy 100 20)
                                   (label "Home:" (layout-policy 50 -1))
                                   (document:id home (edit "some home" (edit-options) (layout-policy 50 -1))))
                             (hbox (layout-policy 100 20)
                                   (label "Gecos:" (layout-policy 50 -1))
                                   (document:id gecos (edit "some gecos" (edit-options) (layout-policy 50 -1)))))))
          (document:id user-passwd
                       (tab "Change Password"
		       	    margin 10
                            (layout-policy 100 100)
                            (vbox (layout-policy 80 -1)
                                  spacing 2
				  margin 2
                                  (hbox (layout-policy 100 50)
                                        (label "Type new password:" (layout-policy 50 -1))
                                        (document:id passwd1 (edit "" (edit-options) echo stars (layout-policy 50 -1))))
                                  (hbox (layout-policy 100 50)
                                        (label "Re-type new password:" (layout-policy 50 -1))
                                        (document:id passwd2 (edit "" (edit-options) echo stars (layout-policy 50 -1)))))))
          current general-options)
         (document:id error-message (label "<b>Error message will be here<b>"
                                           invisible
                                           (layout-policy 100 10)))
         (hbox (layout-policy 100 10)
	       margin 10
               (document:id apply-button (button "Apply" inactive (layout-policy 50 -1)
                                                 (on-click
                                                  (and (change-all)
                                                       (begin (do-edit state #f)
                                                              (do-edit 'call 'on-click))))))
               (document:id discard-button (button "Discard" inactive (layout-policy 50 -1)
                                                   (on-click
                                                    (fill-general-options)
                                                    (do-edit state #f)
                                                    (do-edit 'call 'on-click) )))))))

(vbox expanded
      (hbox
       (layout-policy 100 20)
       (document:id do-edit (button "Edit" inactive
                                    (on-click
                                     (let ((state (userlist activity)))
                                       (do-edit text (if state "View" "Edit"))
                                       (userlist activity (not state))
                                       (toggle-all state)
                                       (for-each (lambda(x) (x activity state))
                                                 (list apply-button discard-button))))))
       (button "New" (on-click
                      (and (eq? #t (document:popup "/users/new"))
                           (update-users))))
       (document:id do-delete (button "Delete" inactive
                                      (on-click
                                       (and (eq? #t (document:popup
                                                               "/std/yesno"
                                                               'message (string-append "Are you really want to delete user "
                                                                                       (userlist text)
                                                                                       "?")))
                                            (woo-catch
                                             (lambda()
                                               (woo-delete (current-user) 'type "local")
                                               (update-users))
                                             (lambda(reason)
                                               (write-error reason))))))))
      (make-viewer))
      
       
(frame:first-button "Quit" (on-click (document:end))) ; use first frame button for exit
(frame:second-button invisible) ;hide second frame button
