(define-module (alterator dbus)
	       :use-module (ice-9 threads)
	       :export (dbus:add-filter
	                dbus:remove-filter))

(dynamic-call "scm_init_dbus" (dynamic-link "libguile-dbus.so"))

(define monitor-mutex (make-mutex))
(define monitor-thread (begin-thread (start-dbus-monitor)))

(define (dbus:add-filter func)
      (with-mutex monitor-mutex
                  (add-dbus-filter func)))

(define (dbus:remove-filter func)
      (with-mutex monitor-mutex
                  (remove-dbus-filter func)))
