#define DBUS_API_SUBJECT_TO_CHANGE

#include <libguile.h>

#include <dbus/dbus.h>
#include <dbus/dbus-glib.h>
#include <dbus/dbus-glib-lowlevel.h>

#include <stdio.h>
#include <string.h>

static DBusConnection *connection = NULL;
static GMainLoop *dbus_loop = NULL;
static void *last_filter = NULL;

static SCM str2scm(const char *str) { return scm_mem2string(str?str:"",str?strlen(str):0); }



static
void do_callback(DBusMessage *message,SCM callback)
{
	SCM args = SCM_EOL;

	args = scm_cons (str2scm(dbus_message_get_sender(message)), args);
	args = scm_cons (str2scm(dbus_message_get_destination(message)), args);
	args = scm_cons (str2scm(dbus_message_get_interface(message)), args);
	args = scm_cons (str2scm(dbus_message_get_member(message)), args);
	
	DBusMessageIter iter;
	dbus_message_iter_init (message, &iter);
	int count=0;
	do{
		switch (dbus_message_iter_get_arg_type (&iter))
		{
			case DBUS_TYPE_STRING:
				{
					const char *str;
          				dbus_message_iter_get_basic (&iter, &str); // -- new interface
					//str=dbus_message_iter_get_string(&iter); // -- old interface
					args = scm_cons (str2scm(str), args);
				}
				break;
			case DBUS_TYPE_INT32:
				{
					dbus_int32_t int32;
					dbus_message_iter_get_basic (&iter, &int32); // -- new interface
	  				//int32 = dbus_message_iter_get_int32 (&iter);// -- old inteface
					args = scm_cons (scm_int2num(int32), args);
				}
				break;
			case DBUS_TYPE_BOOLEAN:
				{
					dbus_bool_t b;
					dbus_message_iter_get_basic (&iter, &b); // -- new interface
	  				//b = dbus_message_iter_get_boolean (&iter);// -- old interface
					args = scm_cons (SCM_BOOL(b), args);
				}
				break;
			default:
				args = scm_cons (SCM_UNSPECIFIED, args);
				break;
		}
		++count;
	}while (dbus_message_iter_next (&iter));

	scm_apply_0(callback,scm_reverse(args));
}



static DBusHandlerResult
filter_func (DBusConnection     *connection,
             DBusMessage        *message,
             void               *user_data)
{
	printf("calling with message and user_data:%d...\n",user_data == last_filter);
	do_callback(message,(SCM)(user_data));
	return (user_data== last_filter)?DBUS_HANDLER_RESULT_HANDLED:DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


SCM scm_add_filter(SCM user_data)
{
	SCM_ASSERT(SCM_NFALSEP(scm_procedure_p(user_data)), user_data, SCM_ARG1, "scm_add_filter");

	puts("adding filter...");
	if (!dbus_connection_add_filter (connection, filter_func, (void*)(user_data), NULL))
		return SCM_BOOL_F;

	last_filter = user_data;//detector of last added filter
	return SCM_BOOL_T;
}

SCM scm_del_filter(SCM user_data)
{
	SCM_ASSERT(SCM_NFALSEP(scm_procedure_p(user_data)), user_data, SCM_ARG1, "scm_add_filter");

	dbus_connection_remove_filter (connection,filter_func,(void*)user_data);
	return SCM_UNSPECIFIED;
}


SCM scm_start_monitor()
{
	if (dbus_loop) g_main_loop_run(dbus_loop);
	return SCM_UNSPECIFIED;
}


SCM scm_stop_monitor()
{
	if (dbus_loop) g_main_loop_quit(dbus_loop);
	return SCM_UNSPECIFIED;
}


void prepare_monitor()
{
	DBusError error;
	DBusBusType type = DBUS_BUS_SYSTEM;
  
	puts("starting monitor...");
  
	dbus_error_init (&error);
  
	if ((connection = dbus_bus_get (type, &error)) == NULL)
	{
		fprintf(stderr,"Failed to open connection to message bus: %s\n",error.message);
		dbus_error_free (&error);
		return;
  	}

  	dbus_bus_add_match(connection,"type='signal'",&error);

  	if (dbus_error_is_set(&error))
	{
  		fprintf (stderr, "Error: %s\n", error.message);
		dbus_error_free (&error);
		return;
	}

	dbus_loop= g_main_loop_new(NULL, FALSE);
  	dbus_connection_setup_with_g_main (connection, NULL);

	puts("ready...");
}


void scm_init_dbus(void)
{
	prepare_monitor();

	scm_c_define_gsubr("start-dbus-monitor", 0, 0, 0,(SCM (*)())scm_start_monitor);
	scm_c_define_gsubr("stop-dbus-monitor", 0, 0, 0,(SCM (*)())scm_stop_monitor);
	
	scm_c_define_gsubr("add-dbus-filter", 1, 0, 0,(SCM (*)())scm_add_filter);
	scm_c_define_gsubr("remove-dbus-filter", 1, 0, 0,(SCM (*)())scm_del_filter);
}
