(use-modules (alterator formula node)
             (alterator formula lambda)
	     (alterator formula links)
             (alterator lookout common)
             (alterator object)
	     (alterator algo))

(define (make-attr-container)
  (define-operation create)
  (let ((attrs '()))
    (object
     #f
     ((create self name value)
      (let ((value (apply make-value value)))
        (set! attrs (acons name value attrs))
        value))

     ((attrs self) attrs)
     
     ((get self attr)
      (let ((name (name-of attr)))
        (cond
         ((assq name attrs) => cdr)
         (else
          (create self name (list (if #f #f)))))))

     ((set self attr)
      (let ((name (name-of attr))
            (value (value-of attr)))
        (cond
         ((assq name attrs) =>
          (lambda (x) (apply (cdr x) value)))
         (else
          (create self name value))))) )))


(define c (make-attr-container))
(define d (make-attr-container))

(define-operation set)
(define-operation value-of)
(define-operation get)
(define-operation attrs)
(define-operation childs)


;(c title (d title))
(set c (make-attribute 'title
                       (get d (make-empty-attribute 'title))))

(format #t "arg=~A~%" (value-of (get c (make-empty-attribute 'title))))

;(d title "title")
(set d (make-attribute 'title "title"))

(format #t "arg=~A~%" (value-of (get c (make-empty-attribute 'title))))
