(document:surround "/std/base")
(document:link to ("/std/functions") type insert)

(document:popup-options width 300 height 500)

(define session (fluid-ref generic-session))

(define (dbus-handler arg:sender arg:destination arg:interface arg:dmember . arg:args)
	(with-fluids ((generic-session session))
		(sender text arg:sender)
		(destination text arg:destination)
		(interface text arg:interface)
		(dmember text arg:dmember)
		(args text (format #f "~S" arg:args))))

(hbox (label "Sender:")
      (document:id sender (label "")))
(hbox (label "Destination:")
      (document:id destination (label "")))
(hbox (label "Interface:")
      (document:id interface (label "")))
(hbox (label "Member:")
      (document:id dmember (label "")))
(hbox (label "Args:")
      (document:id args (label "")))


(document:id start (button "start"
                           (on-click
			      (start inactive)
			      (stop activity #t)
			      (generic-timer-add)
			      (dbus:add-filter dbus-handler))))
                                 
(document:id stop  (button "stop" inactive
			  	(on-click 
			            (stop inactive)
				    (start activity #t)
			  	    (generic-timer-del)
			  	    (dbus:remove-filter dbus-handler))))

