#include <libguile.h>
#include <security/pam_userpass.h>

SCM scm_pam_userpass(SCM service,
		 SCM user,
		 SCM pass,
		 SCM remote_host)
{
	pam_handle_t *pamh;
	pam_userpass_t userpass;
	struct pam_conv conv = {pam_userpass_conv, &userpass};
	int status;


	SCM_ASSERT(SCM_STRINGP(service), service, SCM_ARG1, "scm_pam_userpass");
	SCM_ASSERT(SCM_STRINGP(user), user, SCM_ARG2, "scm_pam_userpass");
	SCM_ASSERT(SCM_STRINGP(pass), pass, SCM_ARG3, "scm_pam_userpass");
	SCM_ASSERT(((remote_host == SCM_UNDEFINED) || SCM_STRINGP(pass)),
		   remote_host, SCM_ARG4, "scm_pam_userpass");

	userpass.user = SCM_STRING_CHARS(user);
	userpass.pass = SCM_STRING_CHARS(pass);

	if (pam_start(SCM_STRING_CHARS(service),
		      SCM_STRING_CHARS(user),
		      &conv, &pamh) != PAM_SUCCESS)
		return SCM_BOOL_F;
	
	if (SCM_UNDEFINED != remote_host)
 	      status = pam_set_item(pamh, PAM_RHOST,
	                            SCM_STRING_CHARS(remote_host));

	if (status == PAM_SUCCESS)
	if ((status = pam_authenticate(pamh, 0)) == PAM_SUCCESS)
		status = pam_acct_mgmt(pamh, 0);

	if (pam_end(pamh, status) != PAM_SUCCESS)
		return SCM_BOOL_F;
		
	return (status == PAM_SUCCESS)?SCM_BOOL_T:SCM_BOOL_F;
}


void scm_init_pam_userpass()
{
	scm_c_define_gsubr("pam-userpass", 3, 1, 0,
			   (SCM (*)())scm_pam_userpass);
}
