(define-module (alterator lookout eval)

  ;;std modules
  :use-module (srfi srfi-1)
  :use-module (srfi srfi-13)

  ;;common extentions
  :use-module (alterator gettext)
  :use-module (alterator glob)
  :use-module (alterator dbus)

  ;;common helper modules
  :use-module (alterator str)
  :use-module (alterator object)
  :use-module (alterator gettext)
  :use-module (alterator glob)
  :use-module (alterator algo)
  :use-module (alterator command)
	     
  ;;lookout: need for correct eval
  :use-module (alterator lookout atlas)
  :use-module (alterator lookout context)
  :use-module (alterator lookout id)
  :use-module (alterator lookout document)
  :use-module (alterator lookout common)
  :use-module (alterator lookout widgets)
  :use-module (alterator lookout globals)
  :use-module (alterator lookout woo)
  :use-module (alterator lookout events)
  :use-module (alterator lookout goto)

  ;;generic, for exported auth variants
  :use-module (alterator generic auth)
  :use-module (alterator generic widgets)
  :use-module (alterator generic session)
  :use-module (alterator generic background)
  
  :export (document:eval))

;;;;;;;;;;;;;;;common declarations of generic callbacks
(declare-event-callback on-click)
(declare-event-callback on-double-click)
(declare-event-callback on-change)
(declare-event-callback on-return)
(declare-event-callback on-select)
(declare-event-callback on-toggle)
(declare-event-callback on-destroy)
;;;;;;;;;;;;;;;


(define real-current-module (current-module))

(define (document-warning . args) (error "try to use insecure function"))

;shield insecure functions like set!
(define (shield-insecure lst)
  (let ((insecure-vars '(set! load use-modules open-output-file
 			  open-file delete-file
			  eval with-output-to-file call-with-output-file
			  module-obarray-set!)))
    `(let ,(map (lambda (x) `(,x document-warning)) insecure-vars) ,@lst)))

(define (document:eval path)
  (eval  (shield-ids
	   (shield-insecure
	     (preprocess-file path))) real-current-module))
