(define (extract-real-id x)
   (if (object? x) (x (make-attribute 'widget-name)) x))

(define (extract-all-real-ids lst)
  (map extract-real-id lst))

;for widgets: we save widgets as a properties: send to http as an ids,or as a real ids
(define (make-generic-default-widget id parend-id)
  (define-operation silent-set)
  

  (let ((attributes '())
        (apriori-attributes '((current . (-1))
                              (activity . (#t))
                              (visibility . (#t)))))
    (object
      #f
      ((set self attr)
       (let ((name (name-of attr))
             (value (value-of attr)))
         (let ((value (extract-all-real-ids value)))
           (silent-set self attr)
           (generic-post-event 'action "set"
                               'widget-id id
                               'attr name
                               'value (string-join (map sure-string (list-flatten value)) ";")))))
      ((silent-set self attr)
       (let ((name (name-of attr))
             (value (value-of attr)))
         (let ((value (extract-all-real-ids value)))
           (set! attributes (alist-set
                             (sure-symbol name)
                             value
                             attributes)))))
      ((get self attr)
       (let ((name (name-of attr)))
         (cond ((or (assq (sure-symbol name) attributes)
                    (assq (sure-symbol name) apriori-attributes)) =>
                    (lambda (x)
                      (let ((x  (cdr x)))
                        (if (= (length x) 1)
                            (car x)
                          x))))
               (else #f))))
      ((bubbling self subcommand . args)
       (case subcommand
	 ((re-create)
	  (for-each (lambda (attr)
		      (let ((name (car attr))
			    (value (cdr attr)))
                        (and (not (eq? name 'widget-id))
                             (generic-post-event 'action "set"
                                                 'widget-id id
                                                 'attr name
                                                 'value (string-join (map sure-string
                                                                          (list-flatten value)) ";")))))
		    attributes)))))))
