;helper functions to work with cgi/fastcgi interface
(define-module (alterator http cgi)
	       :use-module (ice-9 rdelim)
	       :use-module (srfi srfi-1)
	       :use-module (srfi srfi-13)
	       :use-module (alterator str)
	       :export (get-cookie
			set-cookie
			write-text-xml
			write-text-html
			write-unsupported))

;TODO: move to library
(define (get-cookie)
  (filter
    and
    (map (lambda (x)
	   (let ((attrs (map string-trim-both
			     (string-splitting x #\=))))
	     (and (= (length attrs) 2)
		  (cons (car attrs) (cadr attrs)))))
	 (string-splitting (or (getenv "HTTP_COOKIE") "") #\;))))

;TODO: move to library
(define (set-cookie lst)
  (format #t "set-cookie: ~A~%"
	  (string-join
	    (map (lambda (x) (format #f "~A = ~A" (car x) (cdr x))) lst)
	    " ; ")))


(define (write-text-html)
  (display "content-type: text/html") (newline)(newline))

(define (write-text-xml)
  (display "content-type: text/xml") (newline)(newline))

(define (write-unsupported)
  (write-text-html)
  (write-line "<html>
	      <body>
	      <p>GET method <b>are not supported</b> for this form</p>
	      </body>
	      </html>"))
