;special wrappers over two frame buttons
(document:surround "/std/base")

;;;;;;;;;;;;;;;;;

(define (frame:replace url . args)
   (apply document:replace-in-widget (global 'frame:page) url args))


;;;;;;;;;;;;;;;;;

(define (frame:make-page url . args)
  (begin-1 (document:id frame:pg (apply document:subdocument url args))
           (set-global! 'frame:page frame:pg)))


;;;;;;;;;;;;;;;;;

(define (frame:make-buttons-view  . args)
  (begin-1 (document:id frame:bt (apply hbox args))
           (set-global! 'frame:buttons frame:bt)))

(define (frame:buttons-view . args)
  (let ((widget (global 'frame:buttons)))
       (clean-widget widget (lambda() (and widget (apply widget args))))))

;;;;;;;;;;;;;;;;
(define (frame:on-some name thunk)
  (let ((on-some (global name)))
       (and on-some (cell-set! on-some thunk))))

(define (frame:clear-on-some name)
  (set-global! name (make-cell #f)))

(define (frame:call-on-some name)
  (let ((on-some (global name)))
       (and (procedure? (cell-ref on-some))
            ((cell-ref on-some)) )))

(define (frame:on-leave thunk)
  (frame:on-some 'frame:leave thunk))

(define (frame:clear-on-leave)
  (frame:clear-on-some 'frame:leave))

(define (frame:call-on-leave)
  (frame:call-on-some 'frame:leave))

(define (frame:on-apply thunk)
  (frame:on-some 'frame:apply thunk))

(define (frame:clear-on-apply)
  (frame:clear-on-some 'frame:apply))

(define (frame:call-on-apply)
  (frame:call-on-some 'frame:apply))



;;;;;;;;;;;;;;;;;;;;;;
(define (frame:next)
  (let ((p (global 'frame:nx)))
    (and (procedure? p) (p))))

(define (frame:prev)
  (let ((p (global 'frame:pv)))
    (and (procedure? p) (p))))

(define (frame:set-next thunk)
  (set-global! 'frame:nx thunk))

(define (frame:set-prev thunk)
  (set-global! 'frame:pv thunk))

  