LIBRARY = $(shell basename $(shell pwd))

SHAREDLIB = $(LIBRARY).so
SONAME = $(SHAREDLIB).$(SO_MAJOR)

INSTALL = install

prefix = $(RPM_BUILD_ROOT)
libdir = $(prefix)/usr/lib


ifeq ($(MODE),C)

OBJ_EXT=c
CFLAGS += $(BASIC_FLAGS) -I../../include $(RPM_OPT_FLAGS) -fpic
COMPILLER=$(CC)
COMPILLER_FLAGS=$(CFLAGS)
else

OBJ_EXT=cc
CXXFLAGS += $(BASIC_FLAGS) -I../../include $(RPM_OPT_FLAGS) -fpic
COMPILLER=$(CXX)
COMPILLER_FLAGS=$(CXXFLAGS)
endif

LDFLAGS += -lguile

LINKER = $(COMPILLER) $(LDFLAGS) $(TARGET_ARCH)

LIB_SRC = $(shell echo *.$(OBJ_EXT))

LIB_OBJ = $(LIB_SRC:%.$(OBJ_EXT)=%.o)
LIB_DEP = $(LIB_SRC:%.$(OBJ_EXT)=%.d)

TARGETS = $(SHAREDLIB)

.PHONY: all install clean

all: $(TARGETS)

$(SHAREDLIB): $(LIB_OBJ)
	$(LINKER) -shared -Wl,-soname,$(SONAME) -lc $+ $(OUTPUT_OPTION)
	ln -sf $(SHAREDLIB) $(SONAME)

clean:
	$(RM) $(TARGETS) $(LIB_OBJ) $(LIB_DEP) $(SONAME) core *~

install: all
	@$(INSTALL) -pD -m755 $(SHAREDLIB) $(libdir)/$(SHAREDLIB).$(VERSION)
	@ln -sf $(SHAREDLIB).$(VERSION) $(libdir)/$(SONAME)
	@ln -sf $(SONAME) $(libdir)/$(SHAREDLIB)

# We need dependencies only if goal isn't "clean"
ifneq ($(MAKECMDGOALS),clean)

%.d:	%.$(OBJ_EXT)
	@echo Making dependences for $<
	$(SHELL) -ec "$(COMPILLER) -MM $(COMPILLER_FLAGS) $< | sed 's|\($*\)\.o[ :]*|\1.o $@ : |g' > $@; [ -s $@ ] || $(RM) $@"

ifneq ($(LIB_DEP),)
-include $(LIB_DEP)
endif
endif
