

LOCALEDIR=$(datadir)/locale

INSTALL=install
XGETTEXT=xgettext
MSGFMT=msgfmt
MSGMERGE=msgmerge

install-po:
	for i in $(PO_LANGUAGES); do \
	$(INSTALL) -d $(LOCALEDIR)/$$i/LC_MESSAGES; \
	$(MSGFMT) -o $(LOCALEDIR)/$$i/LC_MESSAGES/$(PO_NAME).mo po/$$i.po ;\
	done

update-po:
	$(XGETTEXT) --add-comments --default-domain=po/$(PO_NAME) -L Lisp \
	--keyword=$(PO_KEYWORD) --keyword=i18n:tr $(PO_TRANSLATE)
	for i in $(PO_LANGUAGES);do \
	$(MSGMERGE) po/$$i.po po/$(PO_NAME).po -o $$.new.po && mv $$.new.po po/$$i.po; \
	done
