;main engine to lookout incput documents
(define-module (alterator lookout document)
	       :use-module (alterator algo)
	       :use-module (alterator command)
	       :use-module (alterator lookout uri)
	       :use-module (alterator lookout context)
	       :use-module (alterator lookout globals)
	       :use-module (alterator lookout mapper)
	       :use-module (alterator lookout widgets)
	       :use-module (alterator lookout goto)
	       :use-module (alterator lookout ids)
	       :use-module (alterator lookout dialog)
               :export (document:preprocess
			document:subdocument

			document:popup
			document:end))

;;;;;;;;;;;;;;;;;;;; main preprocessing

;wrapper over command-arg-ref to made code simpler
(define (get-param cmd param)
  (cond-cdr (command-arg-ref cmd param)))

;analyze link instruction
(define (process-link port instruction initial)
  (or
    (let ((type (get-param instruction 'type)))
      (case type
	((popup)
	 (let ((text (get-param instruction 'text))
	       (path (get-param instruction 'to)))
	   (and text path
		(append initial
			(list `(button ,text
				       (on-click
					 (document:popup ,path))))))))
	((rollup)
	 (let ((id (gensym))
	       (text (get-param instruction 'text))
	       (path (get-param instruction 'to)))
	   (and text path
		(append initial
			(list `(button ,text
				       (on-click (,id hidden (not (,id hidden)))))
			      `(id ',id (vbox hidden #t  ,@(document:preprocess path))))))))
	((insert subdocument)
	 (let ((path (get-param instruction 'to)))
	   (and path
		(append initial
			(if (eq? type 'insert)
			  (document:preprocess path)
			  (list (document:subdocument path)))))))
	(else (error "unknown link type " type))))
    initial))


;run subroutine to process next enviroment
(define (process-enviroment port tag initial)
    (append  initial
	     (list `(,@(cdr tag)
		      ,(read-enviroment port (cadr tag) initial)))))

;analyze pair instruction
(define (process-pair port instruction initial)
  (case (car instruction)
    ((document:link) (process-link port instruction initial))
    ((document:envelop) (process-enviroment port instruction initial))
    ((document:end-envelop) (error "parse-error, unexpected end-envelop" (cadr instruction)))
    (else (append initial (list instruction)))))

;analyze instruction we read
(define (process-instruction port instruction initial)
  (cond 
    ((pair? instruction) (process-pair port instruction initial))
    (else (append initial (list instruction)))))

;collect data from some enviroment
;enviroment ends with end-of-file or at document:ent-evelop instruction
(define (read-enviroment port tagname initial)
  (let ((instruction (read port)))
    (if (or (eof-object? instruction)
	    (and (pair? instruction)
		 (eq? (car instruction) 'document:end-envelop)
		 (eq? (cadr instruction) tagname)))
	    initial
	    (read-enviroment port tagname
			     (process-instruction port instruction initial)))))

;preprocess dialog with links and eviroments
(define (preprocess-file file)
  (call-with-input-file file
			(lambda (port)
			  (read-enviroment port (gensym) '() ))))

;same as preprocess-file, but also resolving url
(define (document:preprocess  path)
  (let ((path (lookout-convert-path path)))
    (or  (and path (preprocess-file (car path)))
	 '())))
 
;load widget using url
;return loader function to run later in appropriate context
;todo: will be definition postprocessing here
(define (document:subdocument url)
  (let ((path (lookout-convert-uri url)))
    (and path
	 (lambda()
	   (command-for-each (lambda(name value) (set-global! name value)) path)
	     (map (lambda (x)
		    (eval x (current-module)))
		  (preprocess-file (car path)))))))

;create dialog with appropriate widgets
;Note: we use widget loader function ,cause we want to evaluate all expressions
;in the right context created in this function
(define (init-widget widget-loader . args)
  (and (procedure? widget-loader)
       (let* ((parent (if (null? args) (from-context 'dialog) (car args)))
	      (dlg (make-dialog lookout-main-widget parent)))
	    (with-goto-frame dlg
		 (with-dialog dlg
		      (with-ids (make-ids-holder)
			    (widget-parse-args dlg (widget-loader))
			    ((from-context 'dialog) 'set-context (fluid-ref lookout-context)))))
	    dlg)))

;resolve uri, and create new dialog
;return created dialog class
(define (init-dialog url)
    (with-globals (make-globals '())
      (init-widget (document:subdocument url)
                  (from-context 'dialog))))

;resolve uri, and run new dialog
;return dialog's return code
(define (document:popup . url)
  (let ((dlg (init-dialog url)))
    (and (procedure? dlg)
	 (with-dialog dlg
		      (begin-1
			(dlg 'start)
			(dlg 'delete))))))

;exit current dialog modal loop
(define (document:end . args)
  (apply (from-context 'dialog) 'stop args))
 
