#!/usr/bin/guile
!#

(use-modules (ice-9 rdelim)

             (srfi srfi-1)

             (alterator algo)
             (alterator command)
             (alterator http cgi)
             (alterator generic xml))

;; HELPERS

(define (put-file file)
  (with-input-from-file
      file
    (lambda()
      (write-application-xul)
      (let loop ((l (read-line)))
        (or (eof-object? l)
            (begin (put-message l)
                   (loop (read-line))))))))

(define (assoc-ref name alist)
  (cond-cdr (assoc name alist)))

(define (command-ref name cmd)
  (cond-cdr (command-arg-ref cmd name)))

;; MAIN engines

;;FAKE communication with server
(define (alterator<->cgi message)
  (let ((user (command-ref 'user message))
        (password (command-ref 'password message))
        (session (command-ref 'session-id message)))
    (cond
     ((and user session) '(auth-answer content ((command action "test"))))
     ((and user password) '(auth-answer user "aaa"
                                        session-id "bbb"
                                        content ((command action "get"))))
     (else '(auth-answer content ((command action "forbidden")))))))

;;extract some additional data from cookies, auto envelop to auth request
(define (auth-pre-process message)
  (if (eq? (car message) 'auth-request)
      message
      (let* ((cookie (get-cookie))
             (user (assoc-ref "alterator-user" cookie))
             (password (assoc-ref "alterator-password" cookie))
             (session-id (assoc-ref "alterator-session-id" cookie))
             (remote-addr (remote-address)))

        (append '(auth-request)
                (concatenate
                 (delete #f
                         (list
                          (and remote-addr `(remote-host ,remote-addr))
                          (and user `(user ,user))
                          (and password `(password ,password))
                          (and session-id `(session-id ,session-id)))))
                (list 'content message)))))

;;set cookies to message if auth module want's this, extract content
(define (auth-post-process message)
  (if (eof-object? message)
      '()
      (begin
        (let* ((content (command-ref 'content message))
               (user    (command-ref 'user message))
               (session-id (command-ref 'session-id message)))
                                        ;setup cookies
          (and user
               session-id
               (set-cookie `((alterator-user . ,user)
                             (alterator-session-id . ,session-id))))
          (format (current-error-port) "content=~S~%" content)
                                        ;return content
          (or content '() )))))


;;CGI stuff


;;form retrival
(define (get-method)
  (let* ((cookie (get-cookie))
         (user (assoc-ref "alterator-user" cookie))
         (session-id (assoc-ref "alterator-session-id" cookie)))
    (if (and user session-id)
        (put-file "/var/www/html/xulterator/good.xul");will be output xml generation here, note: default language selection here
        (put-file "/var/www/html/xulterator/warning.xul"))))

;;hidden post communication
(define (post-method message)
  (let ((message (with-input-from-string message (lambda() (read)))))
    (and (not (eof-object? message))
         (put-message
          (with-output-to-string
            (lambda()
              (let ((answer (auth-post-process
                             (alterator<->cgi
                              (auth-pre-process message)))))
                (write-text-xml)
                (write-line "<alterator-answer>")
                (for-each (lambda (cmd)
                            (format #t " ~A" (command->xml cmd)))
                          answer)
                (write-line "</alterator-answer>"))))))))

(get-message
 (lambda (msg)
   (if (string=? (request-method)  "GET")
       (get-method)
       (post-method msg))))

